/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.util;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public final class NumberIncrementer {
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final String CHICKEN_COUNTER_URL = "https://tarantel.yt/breedingcounter.php";
    private static final String START_COUNTER_URL = "https://tarantel.yt/modstarts_1212.php";

    private NumberIncrementer() {
    }

    public static void sendChickenCounter(int numberToAdd) throws IOException, InterruptedException {
        NumberIncrementer.postNumber(CHICKEN_COUNTER_URL, numberToAdd);
    }

    public static void sendStartCounter(int numberToAdd) throws IOException, InterruptedException {
        NumberIncrementer.postNumber(START_COUNTER_URL, numberToAdd);
    }

    private static void postNumber(String url, int numberToAdd) throws IOException, InterruptedException {
        String form = "number_to_add=" + URLEncoder.encode(String.valueOf(numberToAdd), StandardCharsets.UTF_8);
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", "ChickenRoost/1.0 (+minecraft)").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        HttpResponse<Void> response = CLIENT.send(request, HttpResponse.BodyHandlers.discarding());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            // empty if block
        }
    }
}

