/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.recipes.CodecFix;
import net.tarantel.chickenroost.util.Config;

public class Breeder_Recipe
implements Recipe<RecipeInput> {
    public final ItemStack output;
    public final Ingredient ingredient0;
    public final Ingredient ingredient1;
    public final Ingredient ingredient2;
    public final int time;

    public Breeder_Recipe(ItemStack output, Ingredient ingredient0, Ingredient ingredient1, Ingredient ingredient2, int time) {
        this.output = output;
        this.ingredient0 = ingredient0;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.time = time;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public ResourceLocation getId() {
        return ChickenRoostMod.ownresource("basic_breeding");
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getResultEmi() {
        return this.output.copy();
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        if (((Boolean)Config.enablebothways.get()).booleanValue()) {
            return this.ingredient0.test(pContainer.getItem(1)) && this.ingredient1.test(pContainer.getItem(0)) && this.ingredient2.test(pContainer.getItem(2)) || this.ingredient0.test(pContainer.getItem(1)) && this.ingredient1.test(pContainer.getItem(2)) && this.ingredient2.test(pContainer.getItem(0));
        }
        return this.ingredient0.test(pContainer.getItem(1)) && this.ingredient1.test(pContainer.getItem(0)) && this.ingredient2.test(pContainer.getItem(2));
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)3);
        ingredients.add(0, (Object)this.ingredient0);
        ingredients.add(1, (Object)this.ingredient1);
        ingredients.add(2, (Object)this.ingredient2);
        return ingredients;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public String getGroup() {
        return "basic_breeding";
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<Breeder_Recipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ChickenRoostMod.ownresource("basic_breeding");
        private final MapCodec<Breeder_Recipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("food").forGetter(recipe -> recipe.ingredient0), (App)Ingredient.CODEC_NONEMPTY.fieldOf("left-chicken").forGetter(recipe -> recipe.ingredient1), (App)Ingredient.CODEC_NONEMPTY.fieldOf("right-chicken").forGetter(recipe -> recipe.ingredient2), (App)Codec.INT.fieldOf("time").orElse((Object)20).forGetter(recipe -> recipe.time)).apply((Applicative)instance, Breeder_Recipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, Breeder_Recipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<Breeder_Recipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Breeder_Recipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static Breeder_Recipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input0 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient input1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient input2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            int time = buffer.readVarInt();
            return new Breeder_Recipe(output, input0, input1, input2, time);
        }

        private static void write(RegistryFriendlyByteBuf buffer, Breeder_Recipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient0);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient1);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient2);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeVarInt(recipe.time);
        }
    }

    public static class Type
    implements RecipeType<Breeder_Recipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "basic_breeding";

        private Type() {
        }
    }
}

