/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.SoulExtractor_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.Soul_Extractor_Recipe;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Soul_Extractor_Tile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            Soul_Extractor_Tile.this.setChanged();
            if (slot == 0) {
                Soul_Extractor_Tile.this.resetProgress();
            }
            if (!Soul_Extractor_Tile.this.level.isClientSide()) {
                Soul_Extractor_Tile.this.level.sendBlockUpdated(Soul_Extractor_Tile.this.getBlockPos(), Soul_Extractor_Tile.this.getBlockState(), Soul_Extractor_Tile.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ChickenItemBase;
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = (Integer)Config.extractor_speedtimer.get() * 20;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Soul_Extractor_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SOUL_EXTRACTOR.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Soul_Extractor_Tile.this.progress;
                    case 1 -> Soul_Extractor_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        Soul_Extractor_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Soul_Extractor_Tile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"name.chicken_roost.soul_extractor_");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulExtractor_Handler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide()) {
            // empty if block
        }
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("soul_extractor.progress", this.progress);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("soul_extractor.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.SOUL_EXTRACTOR.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Soul_Extractor_Tile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        Soul_Extractor_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        if (Soul_Extractor_Tile.hasRecipe(pEntity)) {
            ++pEntity.progress;
            if (pEntity.progress >= pEntity.maxProgress) {
                Soul_Extractor_Tile.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            Soul_Extractor_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Soul_Extractor_Tile pEntity) {
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null) {
            recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_EXTRACTION_TYPE.get(), Soul_Extractor_Tile.getRecipeInput(inventory), level);
        }
        if (Soul_Extractor_Tile.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(0, 1, false);
            pEntity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)((Soul_Extractor_Recipe)((RecipeHolder)recipe.get()).value()).output.copy().getItem(), pEntity.itemHandler.getStackInSlot(1).getCount() + 1));
            pEntity.resetProgress();
        }
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    private static boolean hasRecipe(Soul_Extractor_Tile entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null && (recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_EXTRACTION_TYPE.get(), Soul_Extractor_Tile.getRecipeInput(inventory), level)).isPresent()) {
            entity.maxProgress = (Integer)Config.extractor_speedtimer.get() * ((Soul_Extractor_Recipe)((RecipeHolder)recipe.get()).value()).time;
        }
        return recipe.isPresent() && Soul_Extractor_Tile.canInsertAmountIntoOutputSlot(inventory) && Soul_Extractor_Tile.canInsertItemIntoOutputSlot(inventory, ((Soul_Extractor_Recipe)((RecipeHolder)recipe.get()).value()).output.copy().getItem().getDefaultInstance());
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.getItem(1).getItem() == stack.getItem() || inventory.getItem(1).isEmpty();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.getItem(1).getMaxStackSize() > inventory.getItem(1).getCount();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    record OrbInput(SimpleContainer inventory) implements RecipeInput
    {
        public ItemStack getItem(int index) {
            return this.inventory.getItem(index).copy();
        }

        public int size() {
            return this.inventory.getContainerSize();
        }
    }
}

