/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.recipes.ModRecipes;

public class Guide_Screen
extends Screen {
    private List<Button> menuButtons = new ArrayList<Button>();
    private String currentContent = "";
    private List<? extends Recipe<?>> recipes;
    private int scrollOffset = 0;
    private RecipeType<?> currentRecipeType;
    public int customindex = 99;
    private static final ResourceLocation SLOT = ChickenRoostMod.ownresource("textures/screens/slot.png");
    private static final ResourceLocation ARROW = ChickenRoostMod.ownresource("textures/screens/arrow.png");

    public Guide_Screen() {
        super((Component)Component.literal((String)""));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int menuWidth = 150;
        int menuMargin = 10;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        String[] menuItems = new String[]{"Start", "Roost Recipes", "Breeder Recipes", "Soul Extractor", "Trainer", "Colored Chicken"};
        for (int i = 0; i < menuItems.length; ++i) {
            int buttonY = menuMargin + i * (buttonHeight + buttonSpacing);
            int menuIndex = i;
            Button button2 = Button.builder((Component)Component.literal((String)menuItems[i]), buttonWidget -> this.onMenuButtonClick(menuIndex)).bounds(menuMargin, buttonY, menuWidth - 2 * menuMargin, buttonHeight).build();
            this.menuButtons.add(button2);
            this.addRenderableWidget((GuiEventListener)button2);
        }
        int closeButtonWidth = 100;
        int closeButtonHeight = 20;
        int closeMargin = 10;
        int closeX = this.width - closeButtonWidth - closeMargin;
        int closeY = this.height - closeButtonHeight - closeMargin;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).bounds(closeX, closeY, closeButtonWidth, closeButtonHeight).build());
        int scrollButtonWidth = 20;
        int scrollButtonHeight = 20;
        int scrollButtonX = this.width - scrollButtonWidth - 10;
        int scrollButtonY = 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191"), button -> this.scrollUp()).bounds(scrollButtonX, scrollButtonY, scrollButtonWidth, scrollButtonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193"), button -> this.scrollDown()).bounds(scrollButtonX, scrollButtonY + scrollButtonHeight + 5, scrollButtonWidth, scrollButtonHeight).build());
        this.onMenuButtonClick(0);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.level == null) {
            this.renderPanorama(guiGraphics, partialTick);
        }
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        int contentBoxX = 160;
        int contentBoxY = 10;
        int contentBoxWidth = this.width - 180;
        int contentBoxHeight = this.height - 60;
        guiGraphics.fill(contentBoxX, contentBoxY, contentBoxX + contentBoxWidth, contentBoxY + contentBoxHeight, -16777216);
        guiGraphics.renderOutline(contentBoxX, contentBoxY, contentBoxWidth, contentBoxHeight, -1);
        guiGraphics.drawString(this.font, this.currentContent, contentBoxX + 10, contentBoxY + 10, 0xFFFFFF, false);
        int startY = contentBoxY + 30;
        int slotSpacing = 30;
        guiGraphics.enableScissor(contentBoxX, contentBoxY + 25, contentBoxX + contentBoxWidth, contentBoxY + contentBoxHeight - 5);
        if (this.currentRecipeType != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                ItemStack input1;
                int temp;
                Recipe<?> recipe = this.recipes.get(i);
                int ingredientCount = recipe.getIngredients().size();
                int slotX1 = contentBoxX + 10;
                int slotX2 = slotX1 + (ingredientCount > 1 ? 40 : 0);
                int slotX3 = slotX2 + (ingredientCount > 2 ? 40 : 0);
                int outputSlotX = slotX3 + 40 + (ingredientCount > 2 ? 60 : 40);
                int slotY = startY + i * slotSpacing - this.scrollOffset;
                int backgroundWidth = outputSlotX + 20 - slotX1;
                guiGraphics.fill(slotX1 - 5, slotY - 5, slotX1 + backgroundWidth + 5, slotY + 25, -2136298838);
                if (this.currentRecipeType == ModRecipes.ROOST_TYPE.get() || this.currentRecipeType == ModRecipes.BASIC_BREEDING_TYPE.get()) {
                    temp = slotX1;
                    slotX1 = slotX2;
                    slotX2 = temp;
                }
                if (this.currentRecipeType == ModRecipes.TRAINER_TYPE.get()) {
                    temp = slotX1;
                    slotX1 = outputSlotX;
                    outputSlotX = temp;
                }
                if ((input1 = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0]) != null) {
                    guiGraphics.renderItem(input1, slotX1, slotY);
                }
                ItemStack input2 = ItemStack.EMPTY;
                if (ingredientCount > 1 && (input2 = ((Ingredient)recipe.getIngredients().get(1)).getItems()[0]) != null) {
                    guiGraphics.renderItem(input2, slotX2, slotY);
                }
                ItemStack input3 = ItemStack.EMPTY;
                if (ingredientCount > 2 && (input3 = ((Ingredient)recipe.getIngredients().get(2)).getItems()[0]) != null) {
                    guiGraphics.renderItem(input3, slotX3, slotY);
                }
                int arrowX = slotX3 + (ingredientCount > 2 ? 40 : 20);
                int arrowY = slotY + 2;
                guiGraphics.blit(ARROW, arrowX, arrowY, 0.0f, 0.0f, 40, 10, 40, 10);
                ItemStack output = recipe.getResultItem(null);
                if (output != null) {
                    guiGraphics.renderItem(output, outputSlotX, slotY);
                }
                if (this.isHovering(slotX1, slotY, 16, 16, mouseX, mouseY) && input1 != ItemStack.EMPTY) {
                    guiGraphics.renderTooltip(this.font, input1, mouseX, mouseY);
                }
                if (this.isHovering(slotX2, slotY, 16, 16, mouseX, mouseY) && input2 != ItemStack.EMPTY) {
                    guiGraphics.renderTooltip(this.font, input2, mouseX, mouseY);
                }
                if (this.isHovering(slotX3, slotY, 16, 16, mouseX, mouseY) && input3 != ItemStack.EMPTY) {
                    guiGraphics.renderTooltip(this.font, input3, mouseX, mouseY);
                }
                if (this.isHovering(outputSlotX, slotY, 16, 16, mouseX, mouseY) && output != ItemStack.EMPTY) {
                    guiGraphics.renderTooltip(this.font, output, mouseX, mouseY);
                }
                guiGraphics.blit(SLOT, slotX1 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                if (input2 != ItemStack.EMPTY) {
                    guiGraphics.blit(SLOT, slotX2 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                if (input3 != ItemStack.EMPTY) {
                    guiGraphics.blit(SLOT, slotX3 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                guiGraphics.blit(SLOT, outputSlotX - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
            }
        }
        guiGraphics.disableScissor();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        this.minecraft.setScreen(null);
    }

    private void onMenuButtonClick(int menuIndex) {
        Level level = Minecraft.getInstance().player.level();
        this.scrollOffset = 0;
        if (level == null) {
            return;
        }
        switch (menuIndex) {
            case 0: {
                this.currentContent = "Welcome to the Chicken Roost Guide!";
                this.currentRecipeType = null;
                this.recipes = List.of();
                break;
            }
            case 1: {
                this.currentContent = "Roost Recipes";
                this.currentRecipeType = ModRecipes.ROOST_TYPE.get();
                this.recipes = level.getRecipeManager().getAllRecipesFor(this.currentRecipeType).stream().map(RecipeHolder::value).filter(recipe -> recipe.getResultItem(null) != null).toList();
                break;
            }
            case 2: {
                this.currentContent = "Breeder Recipes";
                this.currentRecipeType = ModRecipes.BASIC_BREEDING_TYPE.get();
                this.recipes = level.getRecipeManager().getAllRecipesFor(this.currentRecipeType).stream().map(RecipeHolder::value).filter(recipe -> recipe.getResultItem(null) != null).toList();
                break;
            }
            case 3: {
                this.currentContent = "Soul Extractor Recipes";
                this.currentRecipeType = ModRecipes.SOUL_EXTRACTION_TYPE.get();
                this.recipes = level.getRecipeManager().getAllRecipesFor(this.currentRecipeType).stream().map(RecipeHolder::value).filter(recipe -> recipe.getResultItem(null) != null).toList();
                break;
            }
            case 4: {
                this.currentContent = "Trainer Recipes";
                this.currentRecipeType = ModRecipes.TRAINER_TYPE.get();
                this.recipes = level.getRecipeManager().getAllRecipesFor(this.currentRecipeType).stream().map(RecipeHolder::value).filter(recipe -> recipe.getResultItem(null) != null).toList();
                break;
            }
            case 5: {
                this.currentContent = "Colored Chicken Recipes";
                this.currentRecipeType = ModRecipes.THROW_EGG_TYPE.get();
                this.recipes = level.getRecipeManager().getAllRecipesFor(this.currentRecipeType).stream().map(RecipeHolder::value).filter(recipe -> recipe.getResultItem(null) != null).toList();
                break;
            }
            default: {
                this.currentContent = "Invalid Menu";
                this.currentRecipeType = null;
                this.recipes = List.of();
            }
        }
    }

    private void scrollUp() {
        this.scrollOffset = Math.max(0, this.scrollOffset - 30);
    }

    private void scrollDown() {
        this.scrollOffset += 30;
    }
}

