/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="chicken_roost", dist={Dist.CLIENT})
public class ClientBiomeCache {
    private static final Map<String, List<String>> ENTITY_TO_BIOMES = new HashMap<String, List<String>>();
    public static boolean initialized = false;
    private static final Path CACHE_FILE = Minecraft.getInstance().gameDirectory.toPath().resolve("chicken_biomes.json");

    public static void initialize(Level level) {
        if (initialized || level == null) {
            return;
        }
        initialized = true;
        ENTITY_TO_BIOMES.clear();
        RegistryAccess registryAccess = level.registryAccess();
        Registry biomeModifierRegistry = registryAccess.registryOrThrow(NeoForgeRegistries.Keys.BIOME_MODIFIERS);
        Registry biomeRegistry = registryAccess.registryOrThrow(Registries.BIOME);
        for (Map.Entry entry : biomeModifierRegistry.entrySet()) {
            BiomeModifier modifier = (BiomeModifier)entry.getValue();
            if (!(modifier instanceof BiomeModifiers.AddSpawnsBiomeModifier)) continue;
            BiomeModifiers.AddSpawnsBiomeModifier addSpawns = (BiomeModifiers.AddSpawnsBiomeModifier)modifier;
            for (MobSpawnSettings.SpawnerData spawner : addSpawns.spawners()) {
                ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)spawner.type);
                if (entityId == null) continue;
                List biomeList = ENTITY_TO_BIOMES.computeIfAbsent(entityId.toString(), k -> new ArrayList());
                HolderSet selected = addSpawns.biomes();
                if (selected instanceof HolderSet.Named) {
                    HolderSet.Named named = (HolderSet.Named)selected;
                    TagKey tag = named.key();
                    biomeRegistry.getTag(tag).ifPresent(tagged -> {
                        for (Holder holder : tagged) {
                            ResourceLocation loc = biomeRegistry.getKey((Object)((Biome)holder.value()));
                            if (loc == null || biomeList.contains(loc.toString())) continue;
                            biomeList.add(loc.toString());
                        }
                    });
                    continue;
                }
                if (!(selected instanceof HolderSet.Direct)) continue;
                HolderSet.Direct direct = (HolderSet.Direct)selected;
                for (Holder holder : direct) {
                    ResourceLocation loc = biomeRegistry.getKey((Object)((Biome)holder.value()));
                    if (loc == null || biomeList.contains(loc.toString())) continue;
                    biomeList.add(loc.toString());
                }
            }
        }
        ClientBiomeCache.saveToJson();
    }

    public static void saveToJson() {
        try (BufferedWriter writer = Files.newBufferedWriter(CACHE_FILE, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson(ENTITY_TO_BIOMES, (Appendable)writer);
            System.out.println("[GlobalBiomeCache] Cache gespeichert: " + String.valueOf(CACHE_FILE));
        }
        catch (Exception e) {
            System.err.println("[GlobalBiomeCache] Fehler beim Speichern!");
            e.printStackTrace();
        }
    }

    public static void loadFromJson() {
        if (!Files.exists(CACHE_FILE, new LinkOption[0])) {
            System.out.println("[GlobalBiomeCache] Keine Cache-Datei gefunden, wird \u00fcbersprungen");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CACHE_FILE);){
            Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map map = (Map)new Gson().fromJson((Reader)reader, type);
            ENTITY_TO_BIOMES.clear();
            if (map != null) {
                ENTITY_TO_BIOMES.putAll(map);
            }
            initialized = true;
            System.out.println("[GlobalBiomeCache] Cache geladen: " + ENTITY_TO_BIOMES.size() + " Eintr\u00e4ge");
        }
        catch (Exception e) {
            System.err.println("[GlobalBiomeCache] Fehler beim Laden!");
            e.printStackTrace();
        }
    }

    public static List<String> getBiomes(String entityId) {
        return ENTITY_TO_BIOMES.getOrDefault(entityId, List.of());
    }
}

