/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.Roost_Block;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.block.tile.Roost_Tile;
import net.tarantel.chickenroost.handler.Collector_Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Collector_Tile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            Collector_Tile.this.setChanged();
            if (!((Collector_Tile)Collector_Tile.this).level.isClientSide) {
                Collector_Tile.this.level.sendBlockUpdated(Collector_Tile.this.getBlockPos(), Collector_Tile.this.getBlockState(), Collector_Tile.this.getBlockState(), 3);
            }
        }
    };
    private final Set<BlockPos> activeRoosts = new HashSet<BlockPos>();
    private int collectRange = 10;
    protected final ContainerData data = new ContainerData(this){

        public int get(int index) {
            return 0;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 1;
        }
    };
    private int _roostValidationTicker = 0;

    public Collector_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COLLECTOR.get(), pos, state);
    }

    public Set<BlockPos> getActiveRoosts() {
        return Collections.unmodifiableSet(this.activeRoosts);
    }

    public boolean isRoostActive(BlockPos pos) {
        return this.activeRoosts.contains(pos);
    }

    public void setRoostActive(BlockPos pos, boolean active) {
        if (active) {
            this.activeRoosts.add(pos);
        } else {
            this.activeRoosts.remove(pos);
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getCollectRange() {
        return this.collectRange;
    }

    public void setCollectRange(int r) {
        int nr = Math.max(5, Math.min(30, r));
        if (nr != this.collectRange) {
            this.collectRange = nr;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    private boolean isValidRoost(BlockPos pos) {
        if (this.level == null || pos == null) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (!(be instanceof Roost_Tile)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        return state != null && state.getBlock() instanceof Roost_Block;
    }

    private void pruneMissingRoosts() {
        if (this.level == null || this.activeRoosts == null || this.activeRoosts.isEmpty()) {
            return;
        }
        this.activeRoosts.removeIf(pos -> !this.isValidRoost((BlockPos)pos));
    }

    private void maybePruneRoostsPeriodic() {
        if (++this._roostValidationTicker % 20 == 0) {
            this.pruneMissingRoosts();
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        long[] arr = this.activeRoosts.stream().mapToLong(BlockPos::asLong).toArray();
        nbt.putLongArray("collector.roosts", arr);
        nbt.putInt("collector.range", this.collectRange);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        long[] arr;
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.activeRoosts.clear();
        for (long l : arr = nbt.getLongArray("collector.roosts")) {
            this.activeRoosts.add(BlockPos.of((long)l));
        }
        this.collectRange = Math.max(5, Math.min(30, nbt.getInt("collector.range")));
        this.pruneMissingRoosts();
    }

    private static void moveOneStack(IItemHandler from, int fromSlot, IItemHandler to) {
        ItemStack stack = from.getStackInSlot(fromSlot);
        if (stack.isEmpty()) {
            return;
        }
        ItemStack moving = stack.copy();
        for (int i = 0; i < to.getSlots() && !moving.isEmpty(); ++i) {
            moving = to.insertItem(i, moving, false);
        }
        int moved = stack.getCount() - (moving.isEmpty() ? 0 : moving.getCount());
        if (moved > 0) {
            from.extractItem(fromSlot, moved, false);
        }
    }

    private static void collectFromActiveRoosts(Level level, Collector_Tile self) {
        if (self.activeRoosts.isEmpty()) {
            return;
        }
        int r = self.getCollectRange();
        int maxDist2 = r * r;
        for (BlockPos rpos : new HashSet<BlockPos>(self.activeRoosts)) {
            IItemHandler roostInv;
            BlockEntity be;
            if (rpos.distSqr((Vec3i)self.getBlockPos()) > (double)(maxDist2 * 3) || !((be = level.getBlockEntity(rpos)) instanceof Roost_Tile) || (roostInv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, rpos, (Object)null)) == null) continue;
            Collector_Tile.moveOneStack(roostInv, 2, (IItemHandler)self.itemHandler);
        }
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandler;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.COLLECTOR.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Collector_Tile tile) {
        if (level.isClientSide()) {
            return;
        }
        tile.maybePruneRoostsPeriodic();
        Collector_Tile.collectFromActiveRoosts(level, tile);
        Collector_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.chicken_roost.collector");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new Collector_Handler(id, inv, this, this.data);
    }
}

