/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.Roost_Block;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.block.tile.Roost_Tile;
import net.tarantel.chickenroost.handler.Feeder_Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Feeder_Tile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            Feeder_Tile.this.setChanged();
            if (Feeder_Tile.this.level != null && !((Feeder_Tile)Feeder_Tile.this).level.isClientSide) {
                Feeder_Tile.this.level.sendBlockUpdated(Feeder_Tile.this.getBlockPos(), Feeder_Tile.this.getBlockState(), Feeder_Tile.this.getBlockState(), 3);
            }
        }
    };
    private final Set<BlockPos> activeRoosts = new HashSet<BlockPos>();
    private int feedRange = 10;
    private final Map<BlockPos, Item> preferredSeeds = new HashMap<BlockPos, Item>();
    protected final ContainerData data = new ContainerData(this){

        public int get(int index) {
            return 0;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 1;
        }
    };
    private int _roostValidationTicker = 0;

    public Feeder_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FEEDER.get(), pos, state);
    }

    public int getFeedRange() {
        return this.feedRange;
    }

    public void setFeedRange(int r) {
        if (this.feedRange != (r = Math.max(5, Math.min(30, r)))) {
            this.feedRange = r;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void addActiveRoost(BlockPos roost) {
        if (this.activeRoosts.add(roost.immutable())) {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void removeActiveRoost(BlockPos roost) {
        if (this.activeRoosts.remove(roost)) {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public Set<BlockPos> getActiveRoosts() {
        return Collections.unmodifiableSet(this.activeRoosts);
    }

    public void setPreferredSeed(BlockPos roostPos, @Nullable Item item) {
        if (item == null) {
            this.preferredSeeds.remove(roostPos);
        } else {
            this.preferredSeeds.put(roostPos.immutable(), item);
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public Item getPreferredSeed(BlockPos roostPos) {
        return this.preferredSeeds.get(roostPos);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        long[] arr = this.activeRoosts.stream().mapToLong(BlockPos::asLong).toArray();
        nbt.putLongArray("feeder.roosts", arr);
        nbt.putInt("feeder.range", this.feedRange);
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Item> e : this.preferredSeeds.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.putLong("pos", e.getKey().asLong());
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)e.getValue());
            if (key != null) {
                t.putString("item", key.toString());
            }
            list.add((Object)t);
        }
        nbt.put("feeder.preferredSeeds", (Tag)list);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        long[] arr;
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.preferredSeeds.clear();
        if (nbt.contains("feeder.preferredSeeds")) {
            ListTag list = nbt.getList("feeder.preferredSeeds", 10);
            for (int i = 0; i < list.size(); ++i) {
                Item it;
                CompoundTag t = list.getCompound(i);
                BlockPos p = BlockPos.of((long)t.getLong("pos"));
                if (!t.contains("item") || (it = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)t.getString("item")))) == null) continue;
                this.preferredSeeds.put(p, it);
            }
        }
        this.activeRoosts.clear();
        for (long l : arr = nbt.getLongArray("feeder.roosts")) {
            this.activeRoosts.add(BlockPos.of((long)l));
        }
        this.feedRange = Math.max(5, Math.min(30, nbt.getInt("feeder.range")));
        this.pruneMissingRoosts();
    }

    private static void moveOneStack(IItemHandler from, int fromSlot, IItemHandler to) {
        ItemStack stack = from.getStackInSlot(fromSlot);
        if (stack.isEmpty()) {
            return;
        }
        ItemStack moving = stack.copy();
        for (int i = 0; i < to.getSlots() && !moving.isEmpty(); ++i) {
            moving = to.insertItem(i, moving, false);
        }
        int moved = stack.getCount() - (moving.isEmpty() ? 0 : moving.getCount());
        if (moved > 0) {
            from.extractItem(fromSlot, moved, false);
        }
    }

    private static void feedFromActiveRoosts(Level level, Feeder_Tile self) {
        if (self.activeRoosts.isEmpty()) {
            return;
        }
        int r = self.getFeedRange();
        int maxDist2 = r * r;
        for (BlockPos rpos : new HashSet<BlockPos>(self.activeRoosts)) {
            Item desired;
            IItemHandler roostInv;
            BlockEntity be;
            if (rpos.distSqr((Vec3i)self.getBlockPos()) > (double)(maxDist2 * 3) || !((be = level.getBlockEntity(rpos)) instanceof Roost_Tile) || (roostInv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, rpos, (Object)null)) == null) continue;
            ItemStack target = roostInv.getStackInSlot(0);
            Item item = desired = !target.isEmpty() ? target.getItem() : self.preferredSeeds.get(rpos);
            if (desired == null) continue;
            ItemStack probe = new ItemStack((ItemLike)desired, desired.getDefaultMaxStackSize());
            ItemStack remainder = roostInv.insertItem(0, probe.copy(), true);
            int canAccept = probe.getCount() - (remainder.isEmpty() ? 0 : remainder.getCount());
            if (canAccept <= 0) continue;
            int toMove = canAccept;
            for (int i = 0; i < self.itemHandler.getSlots() && toMove > 0; ++i) {
                int moveCount;
                ItemStack extractedSim;
                ItemStack src = self.itemHandler.getStackInSlot(i);
                if (src.isEmpty() || src.getItem() != desired || (extractedSim = self.itemHandler.extractItem(i, moveCount = Math.min(toMove, src.getCount()), true)).isEmpty()) continue;
                ItemStack leftover = roostInv.insertItem(0, extractedSim, false);
                int moved = extractedSim.getCount() - (leftover.isEmpty() ? 0 : leftover.getCount());
                if (moved <= 0) continue;
                self.itemHandler.extractItem(i, moved, false);
                toMove -= moved;
            }
        }
    }

    public void drops() {
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.FEEDER.get());
        NonNullList items = NonNullList.withSize((int)this.itemHandler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    private boolean isValidRoost(BlockPos pos) {
        if (this.level == null || pos == null) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (!(be instanceof Roost_Tile)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        return state != null && state.getBlock() instanceof Roost_Block;
    }

    private void pruneMissingRoosts() {
        if (this.level == null || this.activeRoosts == null || this.activeRoosts.isEmpty()) {
            return;
        }
        this.activeRoosts.removeIf(pos -> !this.isValidRoost((BlockPos)pos));
    }

    private void maybePruneRoostsPeriodic() {
        if (++this._roostValidationTicker % 20 == 0) {
            this.pruneMissingRoosts();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Feeder_Tile tile) {
        if (level.isClientSide()) {
            return;
        }
        tile.maybePruneRoostsPeriodic();
        Feeder_Tile.feedFromActiveRoosts(level, tile);
        Feeder_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.itemHandler;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.chicken_roost.feeder");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new Feeder_Handler(id, inv, this);
    }
}

