/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.item.ModItems;
import net.tarantel.chickenroost.recipes.Breeder_Recipe;
import net.tarantel.chickenroost.util.ChickenConfig;

public class BaseChickenEntity
extends Chicken {
    public int eggTime;
    public ItemStack dropStack;
    public Boolean IS_FIRE;
    public Boolean IS_PROJECTILE;
    public Boolean IS_EXPLOSION;
    public Boolean IS_FALL;
    public Boolean IS_DROWNING;
    public Boolean IS_FREEZING;
    public Boolean IS_LIGHTNING;
    public Boolean IS_WITHER;
    public EntityType<BaseChickenEntity> THISTYPE;
    public int TIER;

    public BaseChickenEntity(EntityType<BaseChickenEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.dropStack = ChickenConfig.getDropStack(type);
        this.eggTime = ChickenConfig.getEggTime(type);
        this.IS_FIRE = ChickenConfig.getIsFire(type);
        this.IS_PROJECTILE = ChickenConfig.getIsProjectile(type);
        this.IS_EXPLOSION = ChickenConfig.getIsExplosion(type);
        this.IS_FALL = ChickenConfig.getIsFall(type);
        this.IS_DROWNING = ChickenConfig.getIsDrowning(type);
        this.IS_FREEZING = ChickenConfig.getIsFreezing(type);
        this.IS_LIGHTNING = ChickenConfig.getIsLightning(type);
        this.IS_WITHER = ChickenConfig.getIsWither(type);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.THISTYPE = type;
        this.TIER = ChickenConfig.getTier(type);
    }

    public boolean isFood(ItemStack stack) {
        return switch (this.TIER) {
            case 1 -> stack.is(ModItems.CHICKEN_FOOD_TIER_1);
            case 2 -> stack.is(ModItems.CHICKEN_FOOD_TIER_2);
            case 3 -> stack.is(ModItems.CHICKEN_FOOD_TIER_3);
            case 4 -> stack.is(ModItems.CHICKEN_FOOD_TIER_4);
            case 5 -> stack.is(ModItems.CHICKEN_FOOD_TIER_5);
            case 6 -> stack.is(ModItems.CHICKEN_FOOD_TIER_6);
            case 7 -> stack.is(ModItems.CHICKEN_FOOD_TIER_7);
            case 8 -> stack.is(ModItems.CHICKEN_FOOD_TIER_8);
            case 9 -> stack.is(ModItems.CHICKEN_FOOD_TIER_9);
            default -> stack.is(ModItems.CHICKEN_FOOD_TIER_1);
        };
    }

    public Chicken getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        if (!(otherParent instanceof BaseChickenEntity)) {
            Chicken fallback = (Chicken)EntityType.CHICKEN.create((Level)level);
            if (fallback != null) {
                fallback.setAge(-24000);
            }
            return fallback;
        }
        BaseChickenEntity parent2 = (BaseChickenEntity)otherParent;
        ResourceLocation id1 = EntityType.getKey((EntityType)this.getType());
        ResourceLocation id2 = EntityType.getKey((EntityType)parent2.getType());
        ItemStack stack1 = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id1));
        ItemStack stack2 = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id2));
        for (RecipeHolder holder : level.getRecipeManager().getAllRecipesFor((RecipeType)Breeder_Recipe.Type.INSTANCE)) {
            Breeder_Recipe recipe = (Breeder_Recipe)holder.value();
            boolean match = recipe.ingredient1.test(stack1) && recipe.ingredient2.test(stack2) || recipe.ingredient1.test(stack2) && recipe.ingredient2.test(stack1);
            if (!match) continue;
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            ResourceLocation resultId = BuiltInRegistries.ITEM.getKey((Object)result.getItem());
            EntityType rawType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resultId);
            if (rawType != null) {
                EntityType childType = rawType;
                BaseChickenEntity child = (BaseChickenEntity)childType.create((Level)level);
                if (child != null) {
                    child.setAge(-24000);
                    ChickenRoostMod.LOGGER.info("Breeding success: {} + {} -> {}", new Object[]{id1, id2, resultId});
                    return child;
                }
                ChickenRoostMod.LOGGER.warn("Failed to create child entity for resultId {}", (Object)resultId);
                continue;
            }
            ChickenRoostMod.LOGGER.warn("No EntityType found for result item {}", (Object)result.getItem());
        }
        Chicken fallback = (Chicken)EntityType.CHICKEN.create((Level)level);
        if (fallback != null) {
            fallback.setAge(-24000);
        }
        ChickenRoostMod.LOGGER.info("No breeding recipe matched: {} + {} -> fallback CHICKEN", (Object)id1, (Object)id2);
        return fallback;
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnType) {
        int max = 10;
        int radius = 20;
        BlockPos pos = this.blockPosition();
        long count = level.getEntitiesOfClass(((Object)((Object)this)).getClass(), new AABB(pos).inflate(16.0 * (double)radius)).size();
        return count < (long)max && super.checkSpawnRules(level, spawnType);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(this.dropStack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isBaby()) {
            return this.getType().getDimensions().scale(0.5f).withEyeHeight(0.2975f);
        }
        return super.getDefaultDimensions(pose);
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && !this.isChickenJockey() && --this.eggTime <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation(this.dropStack);
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.eggTime = this.random.nextInt(6000) + 6000;
        }
    }

    public int getBaseExperienceReward() {
        return this.isChickenJockey() ? 10 : super.getBaseExperienceReward();
    }

    public void readAdditionalSaveData(CompoundTag p_28243_) {
        super.readAdditionalSaveData(p_28243_);
        this.isChickenJockey = p_28243_.getBoolean("IsChickenJockey");
        if (p_28243_.contains("EggLayTime")) {
            this.eggTime = p_28243_.getInt("EggLayTime");
        }
    }

    public void addAdditionalSaveData(CompoundTag p_28257_) {
        super.addAdditionalSaveData(p_28257_);
        p_28257_.putBoolean("IsChickenJockey", this.isChickenJockey);
        p_28257_.putInt("EggLayTime", this.eggTime);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.withDefaultNamespace((String)"entity.chicken.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.withDefaultNamespace((String)"entity.chicken.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.withDefaultNamespace((String)"entity.chicken.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.withDefaultNamespace((String)"entity.chicken.death"));
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypes.ON_FIRE) || damageSource.is(DamageTypes.LAVA) || damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.FIREBALL) || damageSource.is(DamageTypes.FIREWORKS) || damageSource.is(DamageTypes.UNATTRIBUTED_FIREBALL)) {
            if (this.IS_FIRE.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.ARROW) || damageSource.is(DamageTypes.MOB_PROJECTILE)) {
            if (this.IS_PROJECTILE.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.EXPLOSION) || damageSource.is(DamageTypes.PLAYER_EXPLOSION)) {
            if (this.IS_EXPLOSION.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.FALL)) {
            if (this.IS_FALL.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.DROWN)) {
            if (this.IS_DROWNING.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.FREEZE)) {
            if (this.IS_FREEZING.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.LIGHTNING_BOLT)) {
            if (this.IS_LIGHTNING.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        if (damageSource.is(DamageTypes.WITHER) || damageSource.is(DamageTypes.WITHER_SKULL)) {
            if (this.IS_WITHER.booleanValue()) {
                return super.hurt(damageSource, amount);
            }
            return false;
        }
        return super.hurt(damageSource, amount);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 3.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        return builder;
    }
}

