/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tarantel.chickenroost.block.tile.Feeder_Tile;
import net.tarantel.chickenroost.block.tile.Roost_Tile;
import net.tarantel.chickenroost.handler.Feeder_Handler;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.networking.SetFeederRangePayload;
import net.tarantel.chickenroost.networking.SetFeederRoostActivePayload;
import net.tarantel.chickenroost.networking.SetFeederRoostSeedPayload;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Feeder_Screen
extends AbstractContainerScreen<Feeder_Handler> {
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/generic_54.png");
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"chicken_roost", (String)"textures/screens/feedersubmenu.png");
    private boolean showRoostMenu = false;
    private int searchRange = 10;
    private final List<BlockPos> foundRoosts = new ArrayList<BlockPos>();
    private final Set<BlockPos> activeRoostsClient = new HashSet<BlockPos>();
    private final Map<BlockPos, Item> preferredSeedsClient = new HashMap<BlockPos, Item>();
    private int listTopIndex = 0;
    private boolean draggingScrollbar = false;
    private int dragStartMouseY = 0;
    private int dragStartTopIndex = 0;
    private static final int PANEL_W = 164;
    private static final int PANEL_H = 120;
    private static final int HEADER_H = 18;
    private static final int LINE_H = 20;
    private static final int PADDING = 6;
    private static final int SCROLLBAR_W = 6;
    private static final int CHECKBOX_W = 14;

    public Feeder_Screen(Feeder_Handler handler, Inventory inv, Component title) {
        super((AbstractContainerMenu)handler, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    private int overlayX() {
        return this.leftPos + (this.imageWidth - 164) / 2;
    }

    private int overlayY() {
        return this.topPos - 40 + (this.imageHeight - 120) / 2;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Config"), btn -> {
            boolean bl = this.showRoostMenu = !this.showRoostMenu;
            if (this.menu != null) {
                ((Feeder_Handler)this.menu).setUiBlockFeederSlots(this.showRoostMenu);
            }
            if (this.showRoostMenu) {
                this.scanNearbyRoosts();
                this.clampScroll();
            }
        }).bounds(this.leftPos + 4, this.topPos + 4, 35, 12).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), btn -> this.changeRange(-1)).bounds(this.leftPos + 20 + 18 + 5, this.topPos + 4, 12, 12).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), btn -> this.changeRange(1)).bounds(this.leftPos + 34 + 18 + 5, this.topPos + 4, 12, 12).build());
        BlockEntity be = ((Feeder_Handler)this.menu).getBlockEntity();
        if (be instanceof Feeder_Tile) {
            Feeder_Tile ct = (Feeder_Tile)be;
            this.searchRange = ct.getFeedRange();
            this.activeRoostsClient.clear();
            this.activeRoostsClient.addAll(ct.getActiveRoosts());
        }
    }

    public void removed() {
        super.removed();
        if (this.menu != null) {
            ((Feeder_Handler)this.menu).setUiBlockFeederSlots(false);
        }
    }

    private void scanNearbyRoosts() {
        this.foundRoosts.clear();
        BlockEntity be = ((Feeder_Handler)this.menu).getBlockEntity();
        if (!(be instanceof Feeder_Tile)) {
            return;
        }
        Feeder_Tile ct = (Feeder_Tile)be;
        int r = this.searchRange;
        BlockPos center = ct.getBlockPos();
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)center.offset(-r, -r, -r), (BlockPos)center.offset(r, r, r))) {
            BlockEntity roostBe = this.minecraft.level.getBlockEntity(p);
            if (!(roostBe instanceof Roost_Tile)) continue;
            this.foundRoosts.add(p.immutable());
        }
        this.preferredSeedsClient.clear();
        for (BlockPos rp : ct.getActiveRoosts()) {
            Item it = ct.getPreferredSeed(rp);
            if (it == null) continue;
            this.preferredSeedsClient.put(rp, it);
        }
    }

    private void toggleRoost(BlockPos pos) {
        boolean active = this.activeRoostsClient.contains(pos);
        boolean bl = active = !active;
        if (active) {
            this.activeRoostsClient.add(pos);
        } else {
            this.activeRoostsClient.remove(pos);
        }
        BlockEntity be = ((Feeder_Handler)this.menu).getBlockEntity();
        if (be instanceof Feeder_Tile) {
            Feeder_Tile ct = (Feeder_Tile)be;
            PacketDistributor.sendToServer((CustomPacketPayload)new SetFeederRoostActivePayload(ct.getBlockPos(), pos, active), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void changeRange(int delta) {
        BlockEntity be = ((Feeder_Handler)this.menu).getBlockEntity();
        if (!(be instanceof Feeder_Tile)) {
            return;
        }
        Feeder_Tile ct = (Feeder_Tile)be;
        int nr = Math.max(5, Math.min((Integer)Config.feederrange.get(), this.searchRange + delta));
        if (nr == this.searchRange) {
            return;
        }
        this.searchRange = nr;
        this.scanNearbyRoosts();
        this.clampScroll();
        PacketDistributor.sendToServer((CustomPacketPayload)new SetFeederRangePayload(ct.getBlockPos(), this.searchRange), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void setRoostSeed(BlockPos roostPos, @Nullable ItemStack cursor) {
        ResourceLocation key;
        BlockEntity be = ((Feeder_Handler)this.menu).getBlockEntity();
        if (!(be instanceof Feeder_Tile)) {
            return;
        }
        Feeder_Tile ct = (Feeder_Tile)be;
        String id = "";
        if (cursor != null && !cursor.isEmpty() && this.isAllowedGhostItem(cursor.getItem()) && (key = BuiltInRegistries.ITEM.getKey((Object)cursor.getItem())) != null) {
            id = key.toString();
        }
        if (id.isEmpty()) {
            this.preferredSeedsClient.remove(roostPos);
        } else {
            this.preferredSeedsClient.put(roostPos, cursor.getItem());
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SetFeederRoostSeedPayload(ct.getBlockPos(), roostPos, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private boolean isAllowedGhostItem(Item item) {
        return item instanceof ChickenSeedBase;
    }

    protected void renderBg(@NotNull GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        g.blit(GUI, i, j, 0, 0, this.imageWidth, 125);
        g.blit(GUI, i, j + 108 + 17, 0, 126, this.imageWidth, 96);
        if (this.showRoostMenu) {
            this.renderRoostOverlay(g, this.overlayX(), this.overlayY(), mouseX, mouseY);
        }
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(g, mouseX, mouseY, partialTick);
        super.render(g, mouseX, mouseY, partialTick);
        this.renderTooltip(g, mouseX, mouseY);
    }

    private void renderRoostOverlay(GuiGraphics g, int x, int y, int mouseX, int mouseY) {
        g.blit(OVERLAY, x, y, 0.0f, 0.0f, 164, 120, 164, 120);
        g.drawString(this.font, (Component)Component.literal((String)("Range: " + this.searchRange)), x + 164 - 60, y + 4, 0xAAAAAA, false);
        int listX = x + 6;
        int listY = y + 18 + 4;
        int listH = 92;
        int visibleRows = this.getVisibleRows();
        int total = this.foundRoosts.size();
        this.clampScroll();
        int lineY = listY;
        for (int row = 0; row < visibleRows && row + this.listTopIndex < total; ++row) {
            BlockPos pos = this.foundRoosts.get(row + this.listTopIndex);
            boolean active = this.activeRoostsClient.contains(pos);
            int cbX = listX;
            g.fill(cbX, lineY, cbX + 14, lineY + 10, -14671840);
            if (active) {
                g.drawString(this.font, (Component)Component.literal((String)"x"), cbX + 4, lineY, 65280, false);
            }
            String label = this.buildScrollingNameWithCoords(pos);
            g.drawString(this.font, (Component)Component.literal((String)label), cbX + 14 + 4, lineY + 3, 0xFFFFFF, false);
            int slotSize = 16;
            int slotX = x - 20 + 164 - 6 - slotSize;
            int slotY = lineY - 1;
            g.fill(slotX - 1, slotY - 1, slotX + slotSize + 1, slotY + slotSize + 1, -16777216);
            g.fill(slotX, slotY, slotX + slotSize, slotY + slotSize, -12829636);
            Item it = this.preferredSeedsClient.get(pos);
            if (it != null) {
                g.renderItem(new ItemStack((ItemLike)it), slotX, slotY);
            }
            lineY += 20;
        }
        int scrollbarX = x + 164 - 6 - 6;
        g.fill(scrollbarX, listY, scrollbarX + 6, listY + 92, -2145378272);
        if (total > 0) {
            int maxTop = Math.max(0, total - visibleRows);
            float visRatio = Math.min(1.0f, (float)visibleRows / (float)total);
            int thumbH = Math.max(8, Math.min(92, Math.round(visRatio * 92.0f)));
            float pos = maxTop == 0 ? 0.0f : Math.max(0.0f, Math.min(1.0f, (float)this.listTopIndex / (float)maxTop));
            int thumbY = listY + Math.round(pos * (float)(92 - thumbH));
            if (total > visibleRows) {
                g.fill(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbH, -6250336);
            }
        }
    }

    private String buildScrollingNameWithCoords(BlockPos pos) {
        BlockEntity be;
        Object label = "";
        BlockEntity blockEntity = be = this.minecraft != null ? this.minecraft.level.getBlockEntity(pos) : null;
        if (be instanceof Roost_Tile) {
            Roost_Tile roost = (Roost_Tile)be;
            try {
                String nm = roost.getCustomName();
                if (nm != null && !nm.isEmpty()) {
                    int maxVisible = 16;
                    if (nm.length() > maxVisible) {
                        long time = this.minecraft.level.getGameTime();
                        int scrollWidth = nm.length() - maxVisible;
                        int cycle = 160;
                        long t = time % ((long)cycle * 2L);
                        int offset = (int)(t < (long)cycle ? t : (long)cycle * 2L - t);
                        offset = Math.min(scrollWidth, offset);
                        label = nm.substring(offset, Math.min(nm.length(), offset + maxVisible));
                    } else {
                        label = nm;
                    }
                    label = (String)label + " ";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        label = (String)label;
        return label;
    }

    protected void renderLabels(@NotNull GuiGraphics g, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.showRoostMenu) {
            int x = this.overlayX();
            int y = this.overlayY();
            int listX = x + 6;
            int listY = y + 18 + 4;
            int listH = 92;
            int visibleRows = this.getVisibleRows();
            int total = this.foundRoosts.size();
            int lineY = listY;
            for (int row = 0; row < visibleRows && row + this.listTopIndex < total; ++row) {
                BlockPos pos = this.foundRoosts.get(row + this.listTopIndex);
                int cbX1 = listX;
                int cbX2 = cbX1 + 14;
                int cbY1 = lineY;
                int cbY2 = cbY1 + 10;
                int slotSize = 16;
                int slotX1 = x - 20 + 164 - 6 - slotSize;
                int slotX2 = slotX1 + slotSize;
                int slotY1 = lineY - 1;
                int slotY2 = slotY1 + slotSize;
                if (mouseX >= (double)cbX1 && mouseX <= (double)cbX2 && mouseY >= (double)cbY1 && mouseY <= (double)cbY2) {
                    this.toggleRoost(pos);
                    return true;
                }
                if (mouseX >= (double)slotX1 && mouseX <= (double)slotX2 && mouseY >= (double)slotY1 && mouseY <= (double)slotY2) {
                    ItemStack cursor = Minecraft.getInstance().player.containerMenu.getCarried();
                    if (button == 1 || cursor == null || cursor.isEmpty()) {
                        this.setRoostSeed(pos, ItemStack.EMPTY);
                    } else {
                        if (!this.isAllowedGhostItem(cursor.getItem())) {
                            try {
                                Minecraft.getInstance().player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.25f, 0.6f);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return true;
                        }
                        this.setRoostSeed(pos, cursor);
                    }
                    return true;
                }
                lineY += 20;
            }
            int scrollbarX = x + 164 - 6 - 6;
            int scrollbarY1 = listY;
            int scrollbarY2 = listY + 92;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY1 && mouseY <= (double)scrollbarY2) {
                this.draggingScrollbar = true;
                this.dragStartMouseY = (int)mouseY;
                this.dragStartTopIndex = this.listTopIndex;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.showRoostMenu && this.draggingScrollbar) {
            int x = this.overlayX();
            int y = this.overlayY();
            int listY = y + 18 + 4;
            int listH = 92;
            int total = this.foundRoosts.size();
            int visibleRows = this.getVisibleRows();
            int maxTop = Math.max(0, total - visibleRows);
            int dy = (int)mouseY - this.dragStartMouseY;
            int thumbH = Math.max(8, Math.round((float)visibleRows / (float)total * 92.0f));
            int scrollSpace = Math.max(1, 92 - thumbH);
            float frac = (float)dy / (float)scrollSpace;
            int deltaRows = Math.round(frac * (float)maxTop);
            this.listTopIndex = this.dragStartTopIndex + deltaRows;
            this.clampScroll();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.handleWheelScroll(mouseX, mouseY, delta);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double delta = Math.abs(deltaY) > 0.0 ? deltaY : deltaX;
        return this.handleWheelScroll(mouseX, mouseY, delta);
    }

    private boolean handleWheelScroll(double mouseX, double mouseY, double delta) {
        int step;
        if (!this.showRoostMenu) {
            return false;
        }
        int x = this.overlayX();
        int y = this.overlayY();
        int listY = y + 18 + 4;
        if (mouseX < (double)x || mouseX > (double)(x + 164) || mouseY < (double)y || mouseY > (double)(y + 120)) {
            return false;
        }
        int n = step = Feeder_Screen.hasShiftDown() ? 3 : 1;
        this.listTopIndex = delta < 0.0 ? (this.listTopIndex += step) : (this.listTopIndex -= step);
        this.clampScroll();
        return true;
    }

    private void clampScroll() {
        int visibleRows = this.getVisibleRows();
        int total = this.foundRoosts.size();
        int maxTop = Math.max(0, total - visibleRows);
        if (this.listTopIndex < 0) {
            this.listTopIndex = 0;
        }
        if (this.listTopIndex > maxTop) {
            this.listTopIndex = maxTop;
        }
    }

    private int getVisibleRows() {
        int listH = 92;
        return Math.max(1, listH / 20);
    }
}

