/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.mixin;

import dev.anvilcraft.rg.survival.SurvivalPlusPlusServerRules;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
abstract class NaturalSpawnerMixin {
    NaturalSpawnerMixin() {
    }

    @Inject(method={"spawnCategoryForChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private static void spawnCategoryForChunk(MobCategory mobCategory, ServerLevel serverLevel, LevelChunk levelChunk, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback, CallbackInfo ci) {
        if (SurvivalPlusPlusServerRules.qnmdLC < 0) {
            return;
        }
        ChunkPos chunkPos = levelChunk.getPos();
        double chance = SurvivalPlusPlusServerRules.qnmdLC == 0 ? 1.0 : 1.0 / (double)SurvivalPlusPlusServerRules.qnmdLC;
        int i = chunkPos.getMinBlockX() + serverLevel.random.nextInt(16);
        int j = chunkPos.getMinBlockZ() + serverLevel.random.nextInt(16);
        int k = levelChunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        for (int i1 = serverLevel.getMinY(); i1 < k; ++i1) {
            BlockPos blockPos;
            if (serverLevel.random.nextDouble() > chance || (blockPos = new BlockPos(i, i1, j)).getY() < serverLevel.getMinY() + 1) continue;
            NaturalSpawner.spawnCategoryForPosition((MobCategory)mobCategory, (ServerLevel)serverLevel, (ChunkAccess)levelChunk, (BlockPos)blockPos, (NaturalSpawner.SpawnPredicate)spawnPredicate, (NaturalSpawner.AfterSpawnCallback)afterSpawnCallback);
        }
        ci.cancel();
    }
}

