/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.util;

import dev.anvilcraft.rg.survival.util.LargeBarrelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;

public interface ILargeBarrel
extends Container,
IItemHandler {
    public LevelAccessor rg$getLevel();

    public BlockPos rg$getBlockPos();

    default public int getSlots() {
        int size = this.getContainerSize();
        if (LargeBarrelUtil.isLargeBarrel(this.rg$getLevel(), this.rg$getBlockPos())) {
            return size * 2;
        }
        return size;
    }

    @NotNull
    default public ItemStack getStackInSlot(int index) {
        if (!LargeBarrelUtil.isLargeBarrel(this.rg$getLevel(), this.rg$getBlockPos()) || this.rg$getLevel() == null) {
            return this.getItem(index);
        }
        if (index < this.getContainerSize()) {
            return LargeBarrelUtil.getFirstBarrel(this.rg$getLevel(), this.rg$getBlockPos()).getItem(index);
        }
        return LargeBarrelUtil.getSecondBarrel(this.rg$getLevel(), this.rg$getBlockPos()).getItem(index - this.getContainerSize());
    }

    @Unique
    default public void rg$setItem(int index, @NotNull ItemStack itemStack) {
        if (!LargeBarrelUtil.isLargeBarrel(this.rg$getLevel(), this.rg$getBlockPos()) || this.rg$getLevel() == null) {
            this.setItem(index, itemStack);
            return;
        }
        if (index < this.getContainerSize()) {
            LargeBarrelUtil.getFirstBarrel(this.rg$getLevel(), this.rg$getBlockPos()).setItem(index, itemStack);
        } else {
            LargeBarrelUtil.getSecondBarrel(this.rg$getLevel(), this.rg$getBlockPos()).setItem(index - this.getContainerSize(), itemStack);
        }
    }

    @NotNull
    default public ItemStack insertItem(int index, @NotNull ItemStack itemStack, boolean simulate) {
        int slotLimit = this.getSlotLimit(index);
        ItemStack copy = itemStack.copy();
        if (!this.isItemValid(index, copy)) {
            return copy;
        }
        ItemStack stackInSlot = this.getStackInSlot(index);
        int count = stackInSlot.getCount();
        int insertedCount = Math.min(slotLimit, itemStack.getCount() + count);
        int inserted = insertedCount - count;
        copy.setCount(itemStack.getCount() - inserted);
        if (!simulate) {
            if (stackInSlot.isEmpty()) {
                stackInSlot = itemStack.copy();
                stackInSlot.setCount(insertedCount);
                this.rg$setItem(index, stackInSlot);
            } else {
                stackInSlot.setCount(insertedCount);
            }
        }
        return copy;
    }

    @NotNull
    default public ItemStack extractItem(int index, int count, boolean simulate) {
        ItemStack stackInSlot = this.getStackInSlot(index);
        ItemStack copy = stackInSlot.copy();
        int extractedCount = Math.min(stackInSlot.getCount(), count);
        copy.setCount(extractedCount);
        if (!simulate) {
            stackInSlot.setCount(stackInSlot.getCount() - extractedCount);
        }
        return copy;
    }

    default public int getSlotLimit(int index) {
        ItemStack stackInSlot = this.getStackInSlot(index);
        return stackInSlot.isEmpty() ? this.getMaxStackSize() : this.getMaxStackSize(stackInSlot);
    }

    default public boolean isItemValid(int index, @NotNull ItemStack itemStack) {
        ItemStack stackInSlot = this.getStackInSlot(index);
        if (stackInSlot.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)itemStack)) {
            return false;
        }
        return stackInSlot.getCount() < this.getSlotLimit(index);
    }
}

