/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.util;

import dev.anvilcraft.rg.survival.SurvivalPlusPlusServerRules;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class LargeBarrelUtil {
    public static final DoubleBlockCombiner.Combiner<BarrelBlockEntity, Optional<Container>> CONTAINER_COMBINER = new DoubleBlockCombiner.Combiner<BarrelBlockEntity, Optional<Container>>(){

        @NotNull
        public Optional<Container> acceptDouble(final @NotNull BarrelBlockEntity entity, final @NotNull BarrelBlockEntity entity1) {
            return Optional.of(new CompoundContainer(this, (Container)entity, (Container)entity1){

                public void startOpen(@NotNull Player player) {
                    super.startOpen(player);
                    entity.startOpen(player);
                    entity1.startOpen(player);
                }

                public void stopOpen(@NotNull Player player) {
                    super.stopOpen(player);
                    entity.stopOpen(player);
                    entity1.stopOpen(player);
                }
            });
        }

        @NotNull
        public Optional<Container> acceptSingle(@NotNull BarrelBlockEntity entity) {
            return Optional.of(entity);
        }

        @NotNull
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    public static final DoubleBlockCombiner.Combiner<BarrelBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<BarrelBlockEntity, Optional<MenuProvider>>(){

        @NotNull
        public Optional<MenuProvider> acceptDouble(final @NotNull BarrelBlockEntity entity, final @NotNull BarrelBlockEntity entity1) {
            final Container container = ((Optional)CONTAINER_COMBINER.acceptDouble((Object)entity, (Object)entity1)).orElse(null);
            return Optional.of(new MenuProvider(){

                @Nullable
                public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
                    if (entity.canOpen(player) && entity1.canOpen(player)) {
                        entity.unpackLootTable(inventory.player);
                        entity1.unpackLootTable(inventory.player);
                        assert (container != null);
                        return ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)container);
                    }
                    return null;
                }

                @NotNull
                public Component getDisplayName() {
                    if (entity.hasCustomName()) {
                        return entity.getDisplayName();
                    }
                    return entity1.hasCustomName() ? entity1.getDisplayName() : Component.translatable((String)"container.barrel");
                }
            });
        }

        @NotNull
        public Optional<MenuProvider> acceptSingle(@NotNull BarrelBlockEntity entity) {
            return Optional.of(entity);
        }

        @NotNull
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public static boolean isLargeBarrel(LevelAccessor level, BlockPos pos) {
        if (!SurvivalPlusPlusServerRules.largeBarrel) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.BARREL)) {
            return false;
        }
        Direction direction = (Direction)state.getValue((Property)BarrelBlock.FACING);
        Direction opposite = direction.getOpposite();
        BlockPos relative = pos.relative(opposite);
        BlockState state1 = level.getBlockState(relative);
        if (!state1.is(Blocks.BARREL)) {
            return false;
        }
        return ((Direction)state1.getValue((Property)BarrelBlock.FACING)).equals((Object)opposite);
    }

    public static BarrelBlockEntity getFirstBarrel(@NotNull LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Direction value = (Direction)state.getValue((Property)BarrelBlock.FACING);
        if (value == Direction.NORTH || value == Direction.EAST || value == Direction.UP) {
            return (BarrelBlockEntity)level.getBlockEntity(pos);
        }
        BlockPos relative = pos.relative(value.getOpposite());
        return (BarrelBlockEntity)level.getBlockEntity(relative);
    }

    public static BarrelBlockEntity getSecondBarrel(@NotNull LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Direction value = (Direction)state.getValue((Property)BarrelBlock.FACING);
        if (value == Direction.SOUTH || value == Direction.WEST || value == Direction.DOWN) {
            return (BarrelBlockEntity)level.getBlockEntity(pos);
        }
        BlockPos relative = pos.relative(value.getOpposite());
        return (BarrelBlockEntity)level.getBlockEntity(relative);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DoubleBlockCombiner.NeighborCombineResult<? extends BarrelBlockEntity> combine(BarrelBlockEntity entity, Level level, BlockPos pos) {
        if (!LargeBarrelUtil.isLargeBarrel((LevelAccessor)level, pos)) {
            return new DoubleBlockCombiner.NeighborCombineResult.Single((Object)entity);
        }
        BlockState state = level.getBlockState(pos);
        Direction value = (Direction)state.getValue((Property)BarrelBlock.FACING);
        BarrelBlockEntity entity1 = (BarrelBlockEntity)level.getBlockEntity(pos.relative(value.getOpposite()));
        if (entity1 == null) {
            return new DoubleBlockCombiner.NeighborCombineResult.Single((Object)entity);
        }
        if (value == Direction.NORTH || value == Direction.EAST || value == Direction.UP) {
            return new DoubleBlockCombiner.NeighborCombineResult.Double((Object)entity, (Object)entity1);
        }
        return new DoubleBlockCombiner.NeighborCombineResult.Double((Object)entity1, (Object)entity);
    }
}

