/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.mixin;

import dev.anvilcraft.rg.survival.client.SurvivalPlusPlusClientRules;
import dev.anvilcraft.rg.survival.util.IPlayerInjector;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HappyGhast.class})
abstract class HappyGhastMixin
extends LivingEntity {
    protected HappyGhastMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getRiddenInput"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRiddenInput(Player player, Vec3 vec3, @NotNull CallbackInfoReturnable<Vec3> cir) {
        IPlayerInjector injector;
        if (SurvivalPlusPlusClientRules.betterHappyGhastControl) {
            return;
        }
        MobEffectInstance effect = this.getEffect(MobEffects.SPEED);
        double scale = 1.0;
        if (effect != null) {
            int amplifier = effect.getAmplifier();
            scale = 1.0 + 0.2 * (double)(amplifier + 1);
        }
        float f = player.xxa;
        float h = player.isJumping() ? 0.5f : 0.0f;
        float g = player.zza;
        if (player instanceof IPlayerInjector && (injector = (IPlayerInjector)player).rg$isCtrlDown()) {
            h -= 0.5f;
        }
        cir.setReturnValue((Object)new Vec3((double)f, (double)h, (double)g).scale((double)0.18f * scale));
    }
}

