/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.anvilcraft.rg.survival.SurvivalPlusPlusServerRules;
import dev.anvilcraft.rg.survival.util.LargeBarrelUtil;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BarrelBlock.class})
abstract class BarrelBlockMixin {
    BarrelBlockMixin() {
    }

    @WrapOperation(method={"useWithoutItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;openMenu(Lnet/minecraft/world/MenuProvider;)Ljava/util/OptionalInt;")})
    @Nullable
    private OptionalInt getMenuProvider(Player instance, MenuProvider menu, @NotNull Operation<OptionalInt> original) {
        OptionalInt result = (OptionalInt)original.call(new Object[]{instance, menu});
        if (!SurvivalPlusPlusServerRules.largeBarrel) {
            return result;
        }
        if (!(menu instanceof BarrelBlockEntity)) {
            return result;
        }
        BarrelBlockEntity entity = (BarrelBlockEntity)menu;
        Level level = entity.getLevel();
        BlockPos blockPos = entity.getBlockPos();
        if (level == null) {
            return result;
        }
        MenuProvider provider = ((Optional)LargeBarrelUtil.combine(entity, level, blockPos).apply(LargeBarrelUtil.MENU_PROVIDER_COMBINER)).orElse(null);
        return (OptionalInt)original.call(new Object[]{instance, provider});
    }

    @Inject(method={"getAnalogOutputSignal"}, at={@At(value="HEAD")}, cancellable=true)
    private void getAnalogOutputSignal(BlockState blockState, @NotNull Level level, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (!SurvivalPlusPlusServerRules.largeBarrel) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof BarrelBlockEntity)) {
            return;
        }
        BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)entity;
        if (!LargeBarrelUtil.isLargeBarrel((LevelAccessor)level, pos)) {
            return;
        }
        Container container = ((Optional)LargeBarrelUtil.combine(barrelBlockEntity, level, pos).apply(LargeBarrelUtil.CONTAINER_COMBINER)).orElse(null);
        cir.setReturnValue((Object)AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container));
    }
}

