/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.util;

import dev.anvilcraft.rg.api.server.TranslationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.nfunk.jep.JEP;

public class SimpleInGameCalculator {
    public static void handleChat(@NotNull MinecraftServer server, ServerPlayer player, @NotNull String msg) {
        if (msg.startsWith("=")) {
            return;
        }
        server.getPlayerList().broadcastSystemMessage(SimpleInGameCalculator.calculate(msg), false);
    }

    @NotNull
    public static Component calculate(@NotNull String expression) {
        if (expression.startsWith("==")) {
            expression = expression.substring(2);
        }
        JEP jep = new JEP();
        jep.addStandardFunctions();
        jep.addStandardConstants();
        jep.addComplex();
        jep.parseExpression(expression);
        if (!jep.hasError()) {
            double result = jep.getValue();
            return TranslationUtil.trans((String)"simple_in_game_calculator.message", (Object[])new Object[]{result}).withStyle(ChatFormatting.GOLD);
        }
        return TranslationUtil.trans((String)"simple_in_game_calculator.message.illegal_expression", (Object[])new Object[]{jep.getErrorInfo()});
    }
}

