/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.survival.event.listener;

import dev.anvilcraft.rg.survival.SurvivalPlusPlusServerRules;
import dev.anvilcraft.rg.survival.event.EntityGetPistonBehaviourEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="survival_plus_plus")
public class EntityEventListener {
    @SubscribeEvent
    public static void onGetEntityPistonBehaviour(@NotNull EntityGetPistonBehaviourEvent event) {
        Player player;
        if (event.getReaction() == PushReaction.IGNORE) {
            return;
        }
        Entity entity = event.getEntity();
        if (SurvivalPlusPlusServerRules.creativeNoClip && entity instanceof Player && (player = (Player)entity).isCreative() && player.getAbilities().flying) {
            event.setReaction(PushReaction.IGNORE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onMobGriefing(@NotNull EntityMobGriefingEvent event) {
        if (!event.canGrief()) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType type = entity.getType();
        if (type == EntityType.CREEPER && SurvivalPlusPlusServerRules.antiCreeperGriefing) {
            event.setCanGrief(false);
            return;
        }
        if (type == EntityType.GHAST && SurvivalPlusPlusServerRules.antiGhastGriefing) {
            event.setCanGrief(false);
            return;
        }
        if (entity instanceof LargeFireball) {
            LargeFireball fireball = (LargeFireball)entity;
            if (SurvivalPlusPlusServerRules.antiGhastGriefing) {
                if (fireball.getOwner() == null) return;
                if (fireball.getOwner().getType() != EntityType.GHAST) return;
                event.setCanGrief(false);
                return;
            }
        }
        if (type == EntityType.ENDERMAN && SurvivalPlusPlusServerRules.antiEnderManGriefing) {
            event.setCanGrief(false);
            return;
        }
        if (type != EntityType.ENDER_DRAGON) return;
        if (!SurvivalPlusPlusServerRules.antiEnderDragonGriefing) return;
        event.setCanGrief(false);
    }
}

