/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.thexfactor117.levels.architectury.events.custom.AttackCallback;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.AttackUtil;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.ArmorAttribute;
import com.thexfactor117.levels.common.leveling.attributes.BowAttribute;
import com.thexfactor117.levels.common.leveling.attributes.SwordAttribute;
import com.thexfactor117.levels.common.leveling.attributes.WeaponAttributes;
import java.util.List;
import me.shedaniel.architectury.event.events.EntityEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1738;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;

public class EventAttack {
    public static void register() {
        AttackCallback.EVENT.register(event -> {
            class_1297 source = event.getSource().method_5526();
            class_1309 victim = event.getVictim();
            if (source == null) {
                return;
            }
            if (source instanceof class_1657) {
                class_1657 player = (class_1657)source;
                class_1309 enemy = victim;
                class_1799 stack = player.method_6047();
                class_2487 nbt = stack.method_7948();
                if (nbt != null && stack.method_7909() instanceof class_1829) {
                    EventAttack.processHit(event, nbt, stack, enemy, player);
                }
            } else if (source instanceof class_1309 && victim instanceof class_1657) {
                class_1657 player = (class_1657)victim;
                class_1309 enemy = (class_1309)source;
                EventAttack.processArmorHit(event, player, enemy);
            } else if (source instanceof class_1667) {
                class_1667 arrow = (class_1667)source;
                class_1297 shooter = arrow.method_24921();
                if (shooter == null) {
                    return;
                }
                if (shooter instanceof class_1657) {
                    class_1657 player = (class_1657)shooter;
                    class_1309 enemy = victim;
                    class_1799 stack = player.method_6047();
                    class_2487 nbt = stack.method_7948();
                    if (enemy != null && nbt != null && stack.method_7909() instanceof class_1753) {
                        EventAttack.processHit(event, nbt, stack, enemy, player);
                    }
                } else if (shooter instanceof class_1309) {
                    class_1657 player = (class_1657)victim;
                    class_1309 enemy = (class_1309)shooter;
                    if (player != null) {
                        EventAttack.processArmorHit(event, player, enemy);
                    }
                }
            }
        });
        EntityEvent.LIVING_DEATH.register((living, dmgSource) -> {
            class_1297 source = dmgSource.method_5526();
            if (source == null) {
                return class_1269.field_5812;
            }
            if (source instanceof class_1657) {
                class_1657 player = (class_1657)source;
                class_1309 enemy = living;
                class_1799 stack = player.method_6047();
                class_2487 nbt = stack.method_7948();
                if (enemy != null && nbt != null && stack.method_7909() instanceof class_1829) {
                    AttackUtil.processDeath(nbt, stack, enemy, player);
                }
            } else if (source instanceof class_1667) {
                class_1667 arrow = (class_1667)source;
                class_1297 shooter = arrow.method_24921();
                if (shooter == null) {
                    return class_1269.field_5812;
                }
                if (shooter instanceof class_1657) {
                    class_1657 player = (class_1657)shooter;
                    class_1309 enemy = living;
                    class_1799 stack = player.method_6047();
                    class_2487 nbt = stack.method_7948();
                    if (enemy != null && nbt != null && stack.method_7909() instanceof class_1753) {
                        AttackUtil.processDeath(nbt, stack, enemy, player);
                        NBTImpl inbt = NBTHelper.toCommon(nbt);
                        if (BowAttribute.RECOVER.hasAttribute(inbt)) {
                            enemy.method_5870((class_1935)class_1802.field_8107, (int)(Math.random() * 2.0));
                        }
                    }
                }
            }
            return class_1269.field_5812;
        });
    }

    private static void processArmorHit(AttackCallback.AttackInstance event, class_1657 player, class_1309 enemy) {
        class_2487 nbt;
        for (class_1799 stack : player.field_7514.field_7548) {
            class_2487 nbt2 = stack.method_7948();
            if (nbt2 == null || !(stack.method_7909() instanceof class_1738)) continue;
            EventAttack.processHit(event, nbt2, stack, enemy, player);
        }
        class_1799 shield = (class_1799)player.field_7514.field_7544.get(0);
        if (shield.method_7909() instanceof class_1819 && (nbt = shield.method_7948()) != null && player.method_6058() == class_1268.field_5810) {
            EventAttack.processHit(event, nbt, shield, enemy, player);
        }
    }

    private static void processHit(AttackCallback.AttackInstance event, class_2487 nbt, class_1799 stack, class_1309 enemy, class_1657 player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, false);
        EventAttack.useAttributes(nbt, event, stack, player, enemy);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    private static void useAttributes(class_2487 baseNbt, AttackCallback.AttackInstance event, class_1799 stack, class_1657 player, class_1309 enemy) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        if (AnyAttributes.FIRE.hasAttribute(nbt) && AnyAttributes.FIRE.rollChance()) {
            enemy.method_5639((int)AnyAttributes.FIRE.getCalculatedValue(nbt));
        }
        if (AnyAttributes.FROST.hasAttribute(nbt) && AnyAttributes.FROST.rollChance()) {
            enemy.method_6092(new class_1293(class_1294.field_5909, (int)AnyAttributes.FROST.getCalculatedValue(nbt), 10));
        }
        if (AnyAttributes.POISON.hasAttribute(nbt) && AnyAttributes.POISON.rollChance()) {
            enemy.method_6092(new class_1293(class_1294.field_5899, (int)AnyAttributes.POISON.getCalculatedValue(nbt), AnyAttributes.POISON.getAttributeTier(nbt)));
        }
        if (AnyAttributes.DURABLE.hasAttribute(nbt) && AnyAttributes.DURABLE.rollChance()) {
            stack.method_7974(stack.method_7919() - (int)AnyAttributes.DURABLE.getCalculatedValue(nbt));
        }
        float dmgAmount = event.getAmount();
        if (WeaponAttributes.ABSORB.hasAttribute(nbt) && WeaponAttributes.ABSORB.rollChance()) {
            float regenAmount = (float)((double)dmgAmount * WeaponAttributes.ABSORB.getCalculatedValue(nbt) / 100.0);
            player.method_6033(player.method_6032() + regenAmount);
        }
        if (WeaponAttributes.VOID.hasAttribute(nbt)) {
            double chance = WeaponAttributes.VOID.getCalculatedValue(nbt);
            if (Math.random() * 100.0 <= chance) {
                enemy.method_6033(0.001f);
            }
        }
        if (WeaponAttributes.CRITICAL.hasAttribute(nbt) && WeaponAttributes.CRITICAL.rollChance()) {
            float bonus = (float)((double)dmgAmount * WeaponAttributes.CRITICAL.getCalculatedValue(nbt) / 100.0);
            event.setAmount(dmgAmount + bonus);
        }
        if (stack.method_7909() instanceof class_1829 && SwordAttribute.CHAINED.hasAttribute(nbt) && SwordAttribute.CHAINED.rollChance()) {
            double radius = SwordAttribute.CHAINED.getCalculatedValue(nbt);
            class_243 pos = player.method_19538();
            List entityList = enemy.field_6002.method_18467(class_1309.class, new class_238(pos.field_1352 - radius, pos.field_1351 - radius, pos.field_1350 - radius, pos.field_1352 + radius, pos.field_1351 + radius, pos.field_1350 + radius));
            for (class_1309 entity : entityList) {
                if (entity instanceof class_1657 || entity instanceof class_1429) continue;
                entity.method_5643(class_1282.method_5532((class_1657)player), dmgAmount / 2.0f);
            }
        }
        if (stack.method_7909() instanceof class_1738 && ArmorAttribute.MAGICAL.hasAttribute(nbt) && event.getSource().equals(class_1282.field_5846)) {
            event.setAmount((float)((double)dmgAmount * ArmorAttribute.MAGICAL.getCalculatedValue(nbt) / 100.0));
        }
    }
}

