/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.gui;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import io.netty.buffer.Unpooled;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GuiTypeSelection
extends class_437 {
    private class_4185[] attributeButtons;
    private final ItemType type;
    private final List<? extends AttributeBase> attributes;

    public GuiTypeSelection(ItemType type, List<? extends AttributeBase> attributes) {
        super((class_2561)new class_2585("Attribute Selection"));
        this.type = type;
        this.attributes = attributes;
    }

    public void method_25426() {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        class_2487 baseNbt = stack.method_7948();
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        this.attributeButtons = new class_4185[this.attributes.size()];
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            int maxLevel;
            AttributeBase attr = this.attributes.get(i);
            int tier = attr.getAttributeTier(nbt);
            String display = tier == (maxLevel = LevelConfigAttribute.getMaxLevel(attr)) ? attr.getBaseName() + " MAX" : attr.getCompleteName(tier + 1);
            this.attributeButtons[i] = new class_4185(this.field_22789 / 2 - 147, 60 + i * 20, 75, 20, (class_2561)new class_2585(display), this::actionPerformed, this::drawButtonTooltip);
            this.method_25411((class_339)this.attributeButtons[i]);
            this.attributeButtons[i].field_22763 = false;
        }
    }

    @Nullable
    private class_1799 getItemStack() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return null;
        }
        class_1799 stack = player.method_6047();
        if (stack == null) {
            return null;
        }
        ItemType currentType = ItemUtil.type(stack.method_7909());
        if (currentType != this.type) {
            return null;
        }
        return stack;
    }

    private void drawButtonTooltip(class_4185 button, class_4587 poseStack, int mouseX, int mouseY) {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.method_7948());
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (!button.equals(this.attributeButtons[i])) continue;
            AttributeBase attr = this.attributes.get(i);
            class_2585 cmp = new class_2585("");
            attr.getUpgradeSummary(nbt, class_1074::method_4662).stream().map(this::createComponent).forEach(arg_0 -> ((class_2585)cmp).method_10852(arg_0));
            this.method_25424(poseStack, (class_2561)cmp, mouseX + 3, mouseY + 3);
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        class_2487 baseNbt = stack.method_7948();
        ItemType currentType = ItemUtil.type(stack.method_7909());
        if (baseNbt == null || currentType != this.type) {
            return;
        }
        Experience exp = new Experience(stack);
        GuiTypeSelection.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)class_1074.method_4662((String)"levels.misc.attributes", (Object[])new Object[0]), (int)(this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        GuiTypeSelection.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)(class_1074.method_4662((String)"levels.misc.attributes.tokens", (Object[])new Object[0]) + ": " + exp.getAttributeTokens()), (int)(this.field_22789 / 2 - 112), (int)40, (int)0xFFFFFF);
        GuiTypeSelection.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)class_1074.method_4662((String)"levels.misc.attributes.current", (Object[])new Object[0]), (int)(this.field_22789 / 2 + 112), (int)40, (int)0xFFFFFF);
        int k = -1;
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        for (AttributeBase attributeBase : this.attributes) {
            if (!attributeBase.hasAttribute(nbt)) continue;
            GuiTypeSelection.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)attributeBase.getName(nbt), (int)(this.field_22789 / 2 + 112), (int)(60 + 10 * ++k), (int)attributeBase.getHexColor());
        }
        this.displayButtons(stack);
    }

    protected void actionPerformed(class_4185 button) {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.method_7909());
        Experience exp = new Experience(stack);
        if (exp.getAttributeTokens() <= 0) {
            return;
        }
        if (currentType != this.type) {
            return;
        }
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (button != this.attributeButtons[i]) continue;
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.writeInt(i);
            NetworkManager.sendToServer((class_2960)PacketIdentifiers.ATTRIBUTE_SELECTION, (class_2540)byteBuf);
        }
    }

    private void displayButtons(class_1799 stack) {
        Experience exp = new Experience(stack);
        int tokens = exp.getAttributeTokens();
        if (tokens <= 0) {
            for (class_4185 attributeButton : this.attributeButtons) {
                attributeButton.field_22763 = false;
            }
            return;
        }
        class_2487 nbtBase = stack.method_7969();
        NBTImpl nbt = NBTHelper.toCommon(nbtBase);
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            AttributeBase attribute = this.attributes.get(i);
            boolean hasAttribute = attribute.hasAttribute(nbt);
            boolean isMaxLevel = attribute.getAttributeTier(nbt) >= LevelConfigAttribute.getMaxLevel(attribute);
            int cost = attribute.getRarity().getCost();
            boolean shouldEnable = isMaxLevel ? false : (hasAttribute ? true : tokens >= cost);
            this.attributeButtons[i].field_22763 = shouldEnable;
        }
    }

    private class_2561 createComponent(String arg) {
        return new class_2585(arg + "\n");
    }
}

