/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

public class AttackUtil {
    public static void processDeath(class_2487 nbt, class_1799 stack, class_1309 enemy, class_1657 player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, true);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    public static void addExperience(class_1799 stack, class_1309 enemy) {
        int xp;
        Experience exp = new Experience(stack);
        if (exp.isMaxLevel()) {
            return;
        }
        if (stack.method_7909() instanceof class_1829 || stack.method_7909() instanceof class_1753) {
            xp = (int)((double)enemy.method_6063() * 0.2);
            exp.addExperience(xp);
        }
        if (stack.method_7909() instanceof class_1738 || stack.method_7909() instanceof class_1819) {
            xp = 0;
            xp = enemy.method_5996(class_5134.field_23721) != null ? (int)(enemy.method_26825(class_5134.field_23721) * 0.5) : (int)((double)enemy.method_6063() * 0.5);
            exp.addExperience(xp);
        }
    }

    public static void useRarity(class_2487 nbt, class_1799 stack, boolean death) {
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (rarity == Rarity.DEFAULT) {
            return;
        }
        boolean isUnlimitedDurability = Configs.getInstance().main.getBoolean("unlimitedDurability");
        Experience exp = new Experience(stack);
        ItemType type = ItemUtil.type(stack.method_7909());
        if (type != null && death) {
            int addedXp = rarity.generateExperience();
            exp.addExperience(addedXp);
        }
        if (!isUnlimitedDurability && !death) {
            int repairDurability = rarity.generateRarityRepair();
            stack.method_7974(Math.max(stack.method_7919() - repairDurability, 0));
        }
    }

    public static void attemptLevel(class_2487 nbt, class_1799 stack, class_1657 player) {
        new Experience(stack).new Experience.LevelUp(player).levelUp();
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

