/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling;

import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.ArmorAttribute;
import com.thexfactor117.levels.common.leveling.attributes.BowAttribute;
import com.thexfactor117.levels.common.leveling.attributes.SwordAttribute;
import com.thexfactor117.levels.common.leveling.attributes.WeaponAttributes;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.utils.FieldProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public enum ItemType {
    SWORD,
    ARMOR,
    BOW,
    SHIELD;

    private static final Map<ItemType, List<AttributeBase>> ATTRIBUTE_MAPPER;

    public static void init() {
        List<AttributeBase> list = FieldProcessor.getFields(AttributeBase.class, SwordAttribute.class, ArmorAttribute.class, BowAttribute.class, AnyAttributes.class, WeaponAttributes.class);
        for (ItemType type : ItemType.values()) {
            ATTRIBUTE_MAPPER.put(type, new ArrayList());
        }
        ItemType.processAttributes(list);
    }

    public static void processAttributes(List<AttributeBase> list) {
        for (AttributeBase attr : list) {
            for (ItemType type : attr.getAllowedTypes()) {
                ATTRIBUTE_MAPPER.get((Object)type).add(attr);
            }
        }
        for (ItemType type : ItemType.values()) {
            ATTRIBUTE_MAPPER.get((Object)type).sort(Comparator.comparingInt(o -> o.getRarity().getCost()));
        }
    }

    public List<AttributeBase> enabledAttributes() {
        ArrayList<AttributeBase> enabled = new ArrayList<AttributeBase>();
        for (AttributeBase attr : ATTRIBUTE_MAPPER.get((Object)this)) {
            if (!attr.isEnabled()) continue;
            enabled.add(attr);
        }
        return enabled;
    }

    public List<AttributeBase> attributesRaw() {
        return ATTRIBUTE_MAPPER.get((Object)this);
    }

    public List<String> displayAttributes(INBT nbt) {
        ArrayList<String> attributeDisplay = new ArrayList<String>();
        List<AttributeBase> attributes = this.enabledAttributes();
        for (AttributeBase attribute : attributes) {
            if (!attribute.hasAttribute(nbt)) continue;
            attributeDisplay.add(" " + attribute.getColor() + attribute.getName(nbt));
        }
        attributeDisplay.add("");
        return attributeDisplay;
    }

    static {
        ATTRIBUTE_MAPPER = new EnumMap<ItemType, List<AttributeBase>>(ItemType.class);
    }
}

