/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.resources;

import com.thexfactor117.levels.common.config.ConfigEntry;
import com.thexfactor117.levels.common.config.ConfigEntryHolder;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.attributes.display.Formatter;
import com.thexfactor117.levels.common.utils.PropertiesUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Localization
implements Formatter,
ConfigEntryHolder {
    private static Localization localization;
    private final Map<String, Map<String, String>> localeToTranslation = new HashMap<String, Map<String, String>>();
    private final Path directoryLang;

    public static void init(File file) {
        if (localization == null) {
            localization = new Localization(file);
        }
    }

    private Localization(File file) {
        this.directoryLang = file.toPath().resolve(Paths.get("assets", "levels", "lang"));
        this.reload();
    }

    public void reload() {
        File[] files = this.directoryLang.toFile().listFiles();
        if (files == null) {
            System.err.println("Error initializing locale");
            return;
        }
        for (File tlFile : files) {
            String name = tlFile.getName().split("\\.")[0];
            Map<String, String> mapped = PropertiesUtil.loadFile(tlFile);
            this.localeToTranslation.put(name, mapped);
        }
    }

    @Override
    public String format(String str, String ... args) {
        Map<String, String> translator = this.localeToTranslation.get(Configs.getInstance().main.get("language"));
        String text = translator.get(str);
        if (text == null) {
            System.err.println("Error finding locale");
            return str;
        }
        return String.format(text, args);
    }

    @Override
    public ConfigEntry getEntry() {
        HashMap<String, String> def = new HashMap<String, String>();
        def.put("language", "en_US");
        return new ConfigEntry(def);
    }

    @Generated
    public static Localization getLocalization() {
        return localization;
    }
}

