/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import dev.architectury.event.events.client.ClientTooltipEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5134;

public class EventTooltip {
    public static void register() {
        ClientTooltipEvent.ITEM.register((stack, lines, tooltipFlag) -> {
            class_2487 baseNbt = stack.method_7948();
            ItemType type = ItemUtil.type(stack.method_7909());
            if (type == null) {
                return;
            }
            NBTImpl nbt = NBTHelper.toCommon(baseNbt);
            Rarity rarity = Rarity.getRarity(nbt);
            if (rarity != Rarity.DEFAULT) {
                EventTooltip.addTooltips(lines, stack, baseNbt);
            }
        });
    }

    private static void addTooltips(List<class_2561> componentTooltip, class_1799 stack, class_2487 baseNbt) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        DecimalFormat format = new DecimalFormat("#.##");
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("");
        if (stack.method_7909() instanceof class_1829 || stack.method_7909() instanceof class_1743) {
            Multimap attributesWeapon = stack.method_7926(class_1304.field_6173);
            double damage = attributesWeapon.get((Object)class_5134.field_23721).stream().mapToDouble(class_1322::method_6186).sum();
            double speed = attributesWeapon.get((Object)class_5134.field_23723).stream().mapToDouble(class_1322::method_6186).sum();
            tooltip.add(class_124.field_1078 + "+" + format.format(damage) + " Damage");
            tooltip.add(class_124.field_1078 + "+" + format.format(speed + 4.0) + " Attack Speed");
        } else if (stack.method_7909() instanceof class_1738) {
            class_1738 armorItem = (class_1738)stack.method_7909();
            class_1304 slot = armorItem.method_7685();
            Multimap attributesArmor = stack.method_7926(slot);
            double armor = attributesArmor.get((Object)class_5134.field_23724).stream().mapToDouble(class_1322::method_6186).sum();
            double armorToughness = attributesArmor.get((Object)class_5134.field_23725).stream().mapToDouble(class_1322::method_6186).sum();
            tooltip.add(class_124.field_1078 + "+" + format.format(armor) + " Armor");
            tooltip.add(class_124.field_1078 + "+" + format.format(armorToughness) + " Armor Toughness");
        }
        if (!(stack.method_7909() instanceof class_1819) && !(stack.method_7909() instanceof class_1753)) {
            tooltip.add("");
        }
        tooltip.add(rarity.getDisplay(class_1074::method_4662));
        Experience exp = new Experience(stack);
        tooltip.addAll(exp.displayExp(class_1074::method_4662));
        if (baseNbt.method_10550("Unbreakable") == 1) {
            tooltip.add(class_124.field_1080 + class_1074.method_4662((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + class_1074.method_4662((String)"levels.misc.durability.unlimited", (Object[])new Object[0]));
        } else {
            tooltip.add(class_124.field_1080 + class_1074.method_4662((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + (stack.method_7936() - stack.method_7919()) + " / " + stack.method_7936());
        }
        tooltip.add("");
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        boolean leftShift = class_3675.method_15987((long)windowHandle, (int)340);
        boolean rightShift = class_3675.method_15987((long)windowHandle, (int)344);
        if (!leftShift && !rightShift) {
            tooltip.add(class_124.field_1080 + "" + class_124.field_1056 + class_1074.method_4662((String)"levels.misc.attributes.shift", (Object[])new Object[0]));
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(class_2561::method_43470).collect(Collectors.toList()));
            return;
        }
        tooltip.add(class_124.field_1080 + "" + class_124.field_1056 + class_1074.method_4662((String)"levels.misc.attributes", (Object[])new Object[0]));
        ItemType type = ItemUtil.type(stack.method_7909());
        if (type == null) {
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(class_2561::method_43470).collect(Collectors.toList()));
            return;
        }
        tooltip.addAll(type.displayAttributes(nbt));
        componentTooltip.addAll(tooltip.stream().map(class_2561::method_43470).collect(Collectors.toList()));
    }
}

