/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.gui;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GuiTypeSelection
extends class_437 {
    private class_4185[] attributeButtons;
    private final ItemType type;
    private final List<? extends AttributeBase> attributes;

    public GuiTypeSelection(ItemType type, List<? extends AttributeBase> attributes) {
        super((class_2561)class_2561.method_43470((String)"Attribute Selection"));
        this.type = type;
        this.attributes = attributes;
    }

    public void method_25426() {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        class_2487 baseNbt = stack.method_7948();
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        this.attributeButtons = new class_4185[this.attributes.size()];
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            int maxLevel;
            AttributeBase attr = this.attributes.get(i);
            int tier = attr.getAttributeTier(nbt);
            String display = tier == (maxLevel = LevelConfigAttribute.getMaxLevel(attr)) ? attr.getBaseName() + " MAX" : attr.getCompleteName(tier + 1);
            this.attributeButtons[i] = class_4185.method_46430((class_2561)class_2561.method_43470((String)display), this::actionPerformed).method_46434(this.field_22789 / 2 - 147, 60 + i * 20, 75, 20).method_46436(this.getTooltipLines(i)).method_46431();
            this.method_37063((class_364)this.attributeButtons[i]);
            this.attributeButtons[i].field_22763 = false;
        }
    }

    @Nullable
    private class_1799 getItemStack() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return null;
        }
        class_1799 stack = player.method_6047();
        if (stack == null) {
            return null;
        }
        ItemType currentType = ItemUtil.type(stack.method_7909());
        if (currentType != this.type) {
            return null;
        }
        return stack;
    }

    private void drawButtonTooltip(class_4185 button, class_332 guiGraphics, int mouseX, int mouseY) {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.method_7948());
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (!button.equals(this.attributeButtons[i])) continue;
            AttributeBase attr = this.attributes.get(i);
            class_5250 cmp = class_2561.method_43473();
            attr.getUpgradeSummary(nbt, class_1074::method_4662).stream().map(this::createComponent).forEach(arg_0 -> ((class_5250)cmp).method_10852(arg_0));
            guiGraphics.method_51438(this.field_22793, (class_2561)cmp, mouseX + 3, mouseY + 3);
        }
    }

    private class_7919 getTooltipLines(int pos) {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return class_7919.method_47407((class_2561)class_2561.method_43473());
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.method_7948());
        AttributeBase attr = this.attributes.get(pos);
        class_5250 cmp = class_2561.method_43470((String)"");
        attr.getUpgradeSummary(nbt, class_1074::method_4662).stream().map(this::createComponent).forEach(arg_0 -> ((class_5250)cmp).method_10852(arg_0));
        return class_7919.method_47407((class_2561)cmp);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        class_2487 baseNbt = stack.method_7948();
        ItemType currentType = ItemUtil.type(stack.method_7909());
        if (baseNbt == null || currentType != this.type) {
            return;
        }
        Experience exp = new Experience(stack);
        guiGraphics.method_25300(this.field_22793, class_1074.method_4662((String)"levels.misc.attributes", (Object[])new Object[0]), this.field_22789 / 2, 20, 0xFFFFFF);
        guiGraphics.method_25300(this.field_22793, class_1074.method_4662((String)"levels.misc.attributes.tokens", (Object[])new Object[0]) + ": " + exp.getAttributeTokens(), this.field_22789 / 2 - 112, 40, 0xFFFFFF);
        guiGraphics.method_25300(this.field_22793, class_1074.method_4662((String)"levels.misc.attributes.current", (Object[])new Object[0]), this.field_22789 / 2 + 112, 40, 0xFFFFFF);
        int k = -1;
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        for (AttributeBase attributeBase : this.attributes) {
            if (!attributeBase.hasAttribute(nbt)) continue;
            guiGraphics.method_25300(this.field_22793, attributeBase.getName(nbt), this.field_22789 / 2 + 112, 60 + 10 * ++k, attributeBase.getHexColor());
        }
        this.displayButtons(stack);
    }

    protected void actionPerformed(class_4185 button) {
        class_1799 stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.method_7909());
        Experience exp = new Experience(stack);
        if (exp.getAttributeTokens() <= 0) {
            return;
        }
        if (currentType != this.type) {
            return;
        }
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (button != this.attributeButtons[i]) continue;
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.writeInt(i);
            NetworkManager.sendToServer((class_2960)PacketIdentifiers.ATTRIBUTE_SELECTION, (class_2540)byteBuf);
        }
    }

    private void displayButtons(class_1799 stack) {
        Experience exp = new Experience(stack);
        int tokens = exp.getAttributeTokens();
        if (tokens <= 0) {
            for (class_4185 attributeButton : this.attributeButtons) {
                attributeButton.field_22763 = false;
            }
            return;
        }
        class_2487 nbtBase = stack.method_7969();
        NBTImpl nbt = NBTHelper.toCommon(nbtBase);
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            AttributeBase attribute = this.attributes.get(i);
            boolean hasAttribute = attribute.hasAttribute(nbt);
            boolean isMaxLevel = attribute.getAttributeTier(nbt) >= LevelConfigAttribute.getMaxLevel(attribute);
            int cost = attribute.getRarity().getCost();
            boolean shouldEnable = isMaxLevel ? false : (hasAttribute ? true : tokens >= cost);
            this.attributeButtons[i].field_22763 = shouldEnable;
        }
    }

    private class_2561 createComponent(String arg) {
        return class_2561.method_43470((String)(arg + "\n"));
    }
}

