/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.leveling;

import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.common.leveling.exp.ExperienceEditor;
import com.thexfactor117.levels.common.leveling.exp.LevelUpProcessor;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.nbt.NBTType;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;

public class Experience
implements ExperienceEditor {
    private final class_1799 stack;
    private final class_2487 nbt;
    private final INBT inbt;

    public Experience(class_1799 stack) {
        this.stack = stack;
        this.nbt = stack.method_7948();
        this.inbt = NBTHelper.toCommon(this.nbt);
    }

    @Override
    public INBT getNBT() {
        return this.inbt;
    }

    public class LevelUp
    implements LevelUpProcessor {
        private final class_1657 player;

        @Override
        public ExperienceEditor getExpEditor() {
            return Experience.this;
        }

        @Override
        public INBT getNBT() {
            return Experience.this.inbt;
        }

        @Override
        public void notifyLevelUp() {
            String message = Experience.this.stack.method_7954().getString() + class_124.field_1080 + " has leveled up to level " + class_124.field_1065 + Experience.this.getLevel() + class_124.field_1080 + "!";
            this.player.method_43496((class_2561)class_2561.method_43470((String)message));
        }

        @Override
        public boolean isWeapon() {
            return Experience.this.stack.method_7909() instanceof class_1829 || Experience.this.stack.method_7909() instanceof class_1743;
        }

        @Override
        public void levelUpWeapon() {
            double multiplier = Experience.this.nbt.method_10574("Multiplier");
            class_2499 taglist = Experience.this.nbt.method_10554("AttributeModifiers", NBTType.COMPOUND.ordinal());
            class_2487 damageNbt = taglist.method_10602(0);
            class_2487 speedNbt = taglist.method_10602(1);
            double damageAmount = damageNbt.method_10574("Amount");
            double speedAmount = speedNbt.method_10574("Amount");
            double newDamage = damageAmount + damageAmount * multiplier / 2.0;
            double newSpeed = speedAmount - speedAmount * multiplier / 2.0;
            damageNbt.method_10549("Amount", newDamage);
            speedNbt.method_10549("Amount", newSpeed);
        }

        @Override
        public boolean isArmor() {
            return Experience.this.stack.method_7909() instanceof class_1738;
        }

        @Override
        public void levelUpArmor() {
            double multiplier = Experience.this.nbt.method_10574("Multiplier");
            class_2499 taglist = Experience.this.nbt.method_10554("AttributeModifiers", NBTType.COMPOUND.ordinal());
            class_2487 armorNbt = taglist.method_10602(0);
            class_2487 toughnessNbt = taglist.method_10602(1);
            double armorAmount = armorNbt.method_10574("Amount");
            double toughnessAmount = toughnessNbt.method_10574("Amount");
            double newArmor = armorAmount + armorAmount * multiplier / 2.0;
            double newToughness = toughnessAmount - toughnessAmount * multiplier / 2.0;
            armorNbt.method_10549("Amount", newArmor);
            toughnessNbt.method_10549("Amount", newToughness);
        }

        @Override
        public void saveEdits() {
            NBTHelper.saveStackNBT(Experience.this.stack, Experience.this.nbt);
        }

        @Generated
        public LevelUp(class_1657 player) {
            this.player = player;
        }
    }
}

