/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.network;

import com.thexfactor117.levels.architectury.gui.GuiTypeSelection;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.NetworkUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeRarity;
import com.thexfactor117.levels.common.networking.AttributeData;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;

public class GuiTypeResponse {
    private final ItemType type;
    private final List<AttributeData> list;

    public void send(class_3222 player) {
        class_2540 response = new class_2540(Unpooled.buffer());
        response.writeInt(this.type.ordinal());
        response.writeInt(this.list.size());
        for (AttributeData entry : this.list) {
            NetworkUtil.writeString((ByteBuf)response, entry.getKey());
            NetworkUtil.writeString((ByteBuf)response, entry.getBaseName());
            NetworkUtil.writeString((ByteBuf)response, entry.getTranslationKey());
            response.writeInt(entry.getRarity().ordinal());
            response.writeBoolean(entry.isEnabled());
            response.writeInt(entry.getMaxTier());
            response.writeDouble(entry.getBaseValue());
            response.writeDouble(entry.getMultiplier());
            response.writeInt(entry.getHexColor());
            NetworkUtil.writeString((ByteBuf)response, entry.getColor());
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)PacketIdentifiers.SEND_ATTRIBUTE_DATA, (class_2540)response);
    }

    public static GuiTypeResponse parse(ByteBuf byteBuf) {
        ItemType type = ItemType.values()[byteBuf.readInt()];
        int size = byteBuf.readInt();
        ArrayList<AttributeData> data = new ArrayList<AttributeData>(size);
        for (int i = 0; i < size; ++i) {
            String key = NetworkUtil.readString(byteBuf);
            String baseName = NetworkUtil.readString(byteBuf);
            String translationKey = NetworkUtil.readString(byteBuf);
            AttributeRarity rarity = AttributeRarity.values()[byteBuf.readInt()];
            boolean enabled = byteBuf.readBoolean();
            int maxTier = byteBuf.readInt();
            double baseValue = byteBuf.readDouble();
            double multiplier = byteBuf.readDouble();
            int hexColor = byteBuf.readInt();
            String color = NetworkUtil.readString(byteBuf);
            data.add(new AttributeData(key, baseName, translationKey, rarity, enabled, maxTier, baseValue, multiplier, hexColor, color));
        }
        return new GuiTypeResponse(type, data);
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)PacketIdentifiers.SEND_ATTRIBUTE_DATA, (buf, context) -> {
            class_310 mc = class_310.method_1551();
            GuiTypeResponse response = GuiTypeResponse.parse((ByteBuf)buf);
            mc.execute(() -> mc.method_1507((class_437)new GuiTypeSelection(response.type, response.list)));
        });
    }

    @Generated
    public ItemType getType() {
        return this.type;
    }

    @Generated
    public List<AttributeData> getList() {
        return this.list;
    }

    @Generated
    public GuiTypeResponse(ItemType type, List<AttributeData> list) {
        this.type = type;
        this.list = list;
    }
}

