/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.MinecraftAttributes;
import com.thexfactor117.levels.common.leveling.Rarity;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_5134;

public class WeaponHelper {
    private static final Random RND = new Random();

    public static void create(class_1799 stack, class_1657 player) {
        class_2487 baseNbt = stack.method_7948();
        if (baseNbt == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        if (rarity != Rarity.DEFAULT) {
            return;
        }
        Rarity rarityNew = Rarity.getRandomRarity(RND);
        rarityNew.setRarity(nbt);
        if (rarityNew == Rarity.MYTHIC) {
            player.method_5783(class_3417.field_14773, 1.0f, 1.0f);
        }
        if (Configs.getInstance().main.getBoolean("unlimitedDurability")) {
            baseNbt.method_10569("Unbreakable", 1);
        }
        new Experience(stack).setLevel(1);
        baseNbt.method_10549("Multiplier", rarityNew.generateWeightedMultiplier());
        baseNbt.method_10569("HideFlags", 6);
        WeaponHelper.setAttributeModifiers(baseNbt, stack);
        NBTHelper.saveStackNBT(stack, baseNbt);
    }

    private static void setAttributeModifiers(class_2487 nbt, class_1799 stack) {
        class_1792 item = stack.method_7909();
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (item instanceof class_1829 || item instanceof class_1743) {
            Multimap map = item.method_7844(class_1304.field_6173);
            Collection damageCollection = map.get((Object)class_5134.field_23721);
            Collection speedCollection = map.get((Object)class_5134.field_23723);
            class_1322 damageModifier = (class_1322)damageCollection.toArray()[0];
            class_1322 speedModifier = (class_1322)speedCollection.toArray()[0];
            double baseDamage = damageModifier.method_6186() + 1.0;
            double baseSpeed = speedModifier.method_6186();
            double damage = rarity.generateWeightedDamage(baseDamage);
            double speed = rarity.generateWeightedAttackSpeed(baseSpeed);
            class_1322 attackDamage = new class_1322(MinecraftAttributes.ATTACK_DAMAGE_UUID, "attackDamage", damage, class_1322.class_1323.field_6328);
            class_1322 attackSpeed = new class_1322(MinecraftAttributes.ATTACK_SPEED_UUID, "attackSpeed", speed, class_1322.class_1323.field_6328);
            stack.method_7916(class_5134.field_23721, attackDamage, class_1304.field_6173);
            stack.method_7916(class_5134.field_23723, attackSpeed, class_1304.field_6173);
        } else if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            class_1304 slot = armorItem.method_7685();
            Multimap map = item.method_7844(slot);
            Collection armorCollection = map.get((Object)class_5134.field_23724);
            Collection toughnessCollection = map.get((Object)class_5134.field_23725);
            class_1322 armorModifier = (class_1322)armorCollection.toArray()[0];
            class_1322 toughnessModifier = (class_1322)toughnessCollection.toArray()[0];
            double baseArmor = armorModifier.method_6186();
            double baseToughness = toughnessModifier.method_6186();
            double newArmor = rarity.getWeightedArmor(baseArmor);
            double newToughness = rarity.generateWeightedArmorToughness(baseToughness);
            class_1322 armor = new class_1322(MinecraftAttributes.ARMOR_UUID, "armor", newArmor, class_1322.class_1323.field_6328);
            class_1322 toughness = new class_1322(MinecraftAttributes.ARMOR_TOUGHNESS_UUID, "armorToughness", newToughness, class_1322.class_1323.field_6328);
            stack.method_7916(class_5134.field_23724, armor, slot);
            stack.method_7916(class_5134.field_23725, toughness, slot);
        }
    }
}

