/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling.attributes.components;

import com.thexfactor117.levels.common.color.LegacyTextColor;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeRarity;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import com.thexfactor117.levels.common.leveling.attributes.components.config.SimpleConfigAttribute;
import com.thexfactor117.levels.common.leveling.attributes.display.Formatter;
import com.thexfactor117.levels.common.leveling.attributes.display.RomanNumeralDisplay;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.networking.AttributeData;
import com.thexfactor117.levels.common.utils.RomanNumber;
import java.util.ArrayList;
import java.util.List;

public interface AttributeBase
extends RomanNumeralDisplay {
    default public boolean hasAttribute(INBT nbt) {
        return nbt != null && nbt.hasKey(this.getAttributeKey());
    }

    default public void addAttribute(INBT nbt) {
        if (nbt != null) {
            nbt.setInt(this.getAttributeKey(), 1);
        }
    }

    default public void removeAttribute(INBT nbt) {
        if (nbt != null) {
            nbt.remove(this.getAttributeKey());
        }
    }

    default public void setAttributeTier(INBT nbt, int tier) {
        if (nbt != null) {
            nbt.setInt(this.getAttributeKey(), tier);
        }
    }

    default public int getAttributeTier(INBT nbt) {
        return nbt != null ? nbt.getInt(this.getAttributeKey()) : 0;
    }

    default public String getAttributeKey() {
        return "levels:" + this.getBaseName().toLowerCase().replace(' ', '_') + "_tier";
    }

    public AttributeRarity getRarity();

    default public String getName(INBT nbt) {
        return this.getCompleteName(this.getAttributeTier(nbt));
    }

    public boolean isEnabled();

    public String getTranslationKey();

    public ItemType[] getAllowedTypes();

    default public List<String> getUpgradeSummary(INBT nbt, Formatter formatter) {
        int maxLevel = LevelConfigAttribute.getMaxLevel(this);
        int cost = 1;
        if (!this.hasAttribute(nbt)) {
            cost = this.getRarity().getCost();
        }
        if (this.getAttributeTier(nbt) >= maxLevel) {
            cost = 0;
        }
        String translate = this.getTranslationKey();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getColor() + this.getName(nbt));
        list.add((Object)((Object)LegacyTextColor.GRAY) + "Cost: " + cost + " token(s)");
        list.add("");
        list.add(formatter.format(translate, new String[0]));
        list.add("");
        list.add("Tiers:");
        for (int level = 1; level <= maxLevel; ++level) {
            String rmn = RomanNumber.toRoman(level);
            double value = 0.0;
            if (this instanceof SimpleConfigAttribute) {
                value = ((SimpleConfigAttribute)((Object)this)).getCalculatedValue(level);
            }
            String tierTranslationKey = String.format("%s.tier", translate);
            String displayDouble = Math.abs(value % 1.0) > 0.01 ? String.format("%.1f", value) : String.format("%.0f", value);
            String localized = formatter.format(tierTranslationKey, displayDouble);
            list.add(" " + rmn + " - " + this.getColor() + localized);
        }
        return list;
    }

    default public AttributeData netWrapper() {
        double baseValue = 1.0;
        double multiplier = 1.0;
        if (this instanceof SimpleConfigAttribute) {
            SimpleConfigAttribute attr = (SimpleConfigAttribute)((Object)this);
            baseValue = attr.getBaseValue();
            multiplier = attr.getMultiplier();
        }
        return AttributeData.builder().key(this.getAttributeKey()).baseName(this.getBaseName()).translationKey(this.getTranslationKey()).rarity(this.getRarity()).enabled(this.isEnabled()).hexColor(this.getHexColor()).color(this.getColor()).maxTier(LevelConfigAttribute.getMaxLevel(this)).baseValue(baseValue).multiplier(multiplier).build();
    }
}

