/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling.attributes.components.config;

import com.thexfactor117.levels.common.config.ConfigEntry;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import com.thexfactor117.levels.common.nbt.INBT;

public interface SimpleConfigAttribute
extends LevelConfigAttribute {
    public static String keyOf(Enum<?> enm) {
        return enm.getClass().getSimpleName() + "." + enm.name().toLowerCase();
    }

    @Override
    public String getBaseKey();

    public double getDefaultBaseValue();

    public double getDefaultMultiplier();

    default public double getBaseValue() {
        return Configs.getInstance().attributes.getDouble(this.getBaseKey() + ".base_value");
    }

    default public double getMultiplier() {
        return Configs.getInstance().attributes.getDouble(this.getBaseKey() + ".multiplier");
    }

    default public double getCalculatedValue(int level) {
        double baseValue = this.getBaseValue();
        double multiplier = this.getMultiplier();
        double overallMultiplier = Math.pow(multiplier, level - 1);
        return baseValue * overallMultiplier;
    }

    public double getCalculatedValue(INBT var1);

    @Override
    default public ConfigEntry getEntry() {
        ConfigEntry cfg = LevelConfigAttribute.super.getEntry();
        cfg.set(this.getBaseKey() + ".base_value", String.valueOf(this.getDefaultBaseValue()));
        cfg.set(this.getBaseKey() + ".multiplier", String.valueOf(this.getDefaultMultiplier()));
        return cfg;
    }
}

