/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling.exp;

import com.thexfactor117.levels.common.color.LegacyTextColor;
import com.thexfactor117.levels.common.config.ConfigManager;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.attributes.display.Formatter;
import com.thexfactor117.levels.common.nbt.INBTHolder;
import java.util.ArrayList;
import java.util.List;

public interface ExperienceEditor
extends INBTHolder {
    public static final String LEVEL_KEY = "levels:level";
    public static final String EXPERIENCE_KEY = "levels:experience";
    public static final String TOKENS_KEY = "levels:tokens";

    default public int getLevel() {
        return this.getNBT() != null ? this.getNBT().getInt(LEVEL_KEY) : 1;
    }

    default public void setLevel(int level) {
        if (this.getNBT() == null) {
            return;
        }
        if (level > 0) {
            this.getNBT().setInt(LEVEL_KEY, level);
        } else {
            this.getNBT().remove(LEVEL_KEY);
        }
    }

    default public boolean isMaxLevel() {
        return this.getLevel() >= Configs.getInstance().main.getInt("maxLevel");
    }

    default public int getExperience() {
        return this.getNBT() != null ? this.getNBT().getInt(EXPERIENCE_KEY) : 1;
    }

    default public void setExperience(int experience) {
        if (this.getNBT() == null) {
            return;
        }
        if (experience > 0) {
            this.getNBT().setInt(EXPERIENCE_KEY, experience);
        } else {
            this.getNBT().remove(EXPERIENCE_KEY);
        }
    }

    default public void addExperience(int experience) {
        this.setExperience(this.getExperience() + experience);
    }

    default public int getAttributeTokens() {
        return this.getNBT() != null ? this.getNBT().getInt(TOKENS_KEY) : 0;
    }

    default public void setAttributeTokens(int tokens) {
        if (this.getNBT() == null) {
            return;
        }
        if (tokens > 0) {
            this.getNBT().setInt(TOKENS_KEY, tokens);
        } else {
            this.getNBT().remove(TOKENS_KEY);
        }
    }

    default public void addAttributeTokens(int toAdd) {
        this.setAttributeTokens(this.getAttributeTokens() + toAdd);
    }

    public static int getNextLevelExperience(int currentLevel) {
        ConfigManager cfg = Configs.getInstance().main;
        return (int)(Math.pow(currentLevel, cfg.getDouble("expExponent")) * cfg.getDouble("expMultiplier"));
    }

    default public List<String> displayExp(Formatter formatter) {
        ArrayList<String> display = new ArrayList<String>();
        int level = this.getLevel();
        if (this.isMaxLevel()) {
            display.add((Object)((Object)LegacyTextColor.GRAY) + formatter.format("levels.misc.level", new String[0]) + ": " + formatter.format("levels.misc.max", new String[0]));
            display.add((Object)((Object)LegacyTextColor.GRAY) + formatter.format("levels.misc.experience", new String[0]) + ": " + formatter.format("levels.misc.max", new String[0]));
        } else {
            display.add((Object)((Object)LegacyTextColor.GRAY) + formatter.format("levels.misc.level", new String[0]) + ": " + level);
            display.add((Object)((Object)LegacyTextColor.GRAY) + formatter.format("levels.misc.experience", new String[0]) + ": " + this.getExperience() + " / " + ExperienceEditor.getNextLevelExperience(level));
        }
        return display;
    }
}

