/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.thexfactor117.levels.architectury.events.custom.AttackCallback;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.AttackUtil;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.ArmorAttribute;
import com.thexfactor117.levels.common.leveling.attributes.BowAttribute;
import com.thexfactor117.levels.common.leveling.attributes.SwordAttribute;
import com.thexfactor117.levels.common.leveling.attributes.WeaponAttributes;
import java.util.List;
import me.shedaniel.architectury.event.events.EntityEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class EventAttack {
    public static void register() {
        AttackCallback.EVENT.register(event -> {
            Entity source = event.getSource().func_76364_f();
            LivingEntity victim = event.getVictim();
            if (source == null) {
                return;
            }
            if (source instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)source;
                LivingEntity enemy = victim;
                ItemStack stack = player.func_184614_ca();
                CompoundNBT nbt = stack.func_196082_o();
                if (nbt != null && stack.func_77973_b() instanceof SwordItem) {
                    EventAttack.processHit(event, nbt, stack, enemy, player);
                }
            } else if (source instanceof LivingEntity && victim instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)victim;
                LivingEntity enemy = (LivingEntity)source;
                EventAttack.processArmorHit(event, player, enemy);
            } else if (source instanceof ArrowEntity) {
                ArrowEntity arrow = (ArrowEntity)source;
                Entity shooter = arrow.func_234616_v_();
                if (shooter == null) {
                    return;
                }
                if (shooter instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)shooter;
                    LivingEntity enemy = victim;
                    ItemStack stack = player.func_184614_ca();
                    CompoundNBT nbt = stack.func_196082_o();
                    if (enemy != null && nbt != null && stack.func_77973_b() instanceof BowItem) {
                        EventAttack.processHit(event, nbt, stack, enemy, player);
                    }
                } else if (shooter instanceof LivingEntity) {
                    PlayerEntity player = (PlayerEntity)victim;
                    LivingEntity enemy = (LivingEntity)shooter;
                    if (player != null) {
                        EventAttack.processArmorHit(event, player, enemy);
                    }
                }
            }
        });
        EntityEvent.LIVING_DEATH.register((living, dmgSource) -> {
            Entity source = dmgSource.func_76364_f();
            if (source == null) {
                return ActionResultType.SUCCESS;
            }
            if (source instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)source;
                LivingEntity enemy = living;
                ItemStack stack = player.func_184614_ca();
                CompoundNBT nbt = stack.func_196082_o();
                if (enemy != null && nbt != null && stack.func_77973_b() instanceof SwordItem) {
                    AttackUtil.processDeath(nbt, stack, enemy, player);
                }
            } else if (source instanceof ArrowEntity) {
                ArrowEntity arrow = (ArrowEntity)source;
                Entity shooter = arrow.func_234616_v_();
                if (shooter == null) {
                    return ActionResultType.SUCCESS;
                }
                if (shooter instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)shooter;
                    LivingEntity enemy = living;
                    ItemStack stack = player.func_184614_ca();
                    CompoundNBT nbt = stack.func_196082_o();
                    if (enemy != null && nbt != null && stack.func_77973_b() instanceof BowItem) {
                        AttackUtil.processDeath(nbt, stack, enemy, player);
                        NBTImpl inbt = NBTHelper.toCommon(nbt);
                        if (BowAttribute.RECOVER.hasAttribute(inbt)) {
                            enemy.func_199702_a((IItemProvider)Items.field_151032_g, (int)(Math.random() * 2.0));
                        }
                    }
                }
            }
            return ActionResultType.SUCCESS;
        });
    }

    private static void processArmorHit(AttackCallback.AttackInstance event, PlayerEntity player, LivingEntity enemy) {
        CompoundNBT nbt;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            CompoundNBT nbt2 = stack.func_196082_o();
            if (nbt2 == null || !(stack.func_77973_b() instanceof ArmorItem)) continue;
            EventAttack.processHit(event, nbt2, stack, enemy, player);
        }
        ItemStack shield = (ItemStack)player.field_71071_by.field_184439_c.get(0);
        if (shield.func_77973_b() instanceof ShieldItem && (nbt = shield.func_196082_o()) != null && player.func_184600_cs() == Hand.OFF_HAND) {
            EventAttack.processHit(event, nbt, shield, enemy, player);
        }
    }

    private static void processHit(AttackCallback.AttackInstance event, CompoundNBT nbt, ItemStack stack, LivingEntity enemy, PlayerEntity player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, false);
        EventAttack.useAttributes(nbt, event, stack, player, enemy);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    private static void useAttributes(CompoundNBT baseNbt, AttackCallback.AttackInstance event, ItemStack stack, PlayerEntity player, LivingEntity enemy) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        if (AnyAttributes.FIRE.hasAttribute(nbt) && AnyAttributes.FIRE.rollChance()) {
            enemy.func_70015_d((int)AnyAttributes.FIRE.getCalculatedValue(nbt));
        }
        if (AnyAttributes.FROST.hasAttribute(nbt) && AnyAttributes.FROST.rollChance()) {
            enemy.func_195064_c(new EffectInstance(Effects.field_76421_d, (int)AnyAttributes.FROST.getCalculatedValue(nbt), 10));
        }
        if (AnyAttributes.POISON.hasAttribute(nbt) && AnyAttributes.POISON.rollChance()) {
            enemy.func_195064_c(new EffectInstance(Effects.field_76436_u, (int)AnyAttributes.POISON.getCalculatedValue(nbt), AnyAttributes.POISON.getAttributeTier(nbt)));
        }
        if (AnyAttributes.DURABLE.hasAttribute(nbt) && AnyAttributes.DURABLE.rollChance()) {
            stack.func_196085_b(stack.func_77952_i() - (int)AnyAttributes.DURABLE.getCalculatedValue(nbt));
        }
        float dmgAmount = event.getAmount();
        if (WeaponAttributes.ABSORB.hasAttribute(nbt) && WeaponAttributes.ABSORB.rollChance()) {
            float regenAmount = (float)((double)dmgAmount * WeaponAttributes.ABSORB.getCalculatedValue(nbt) / 100.0);
            player.func_70606_j(player.func_110143_aJ() + regenAmount);
        }
        if (WeaponAttributes.VOID.hasAttribute(nbt)) {
            double chance = WeaponAttributes.VOID.getCalculatedValue(nbt);
            if (Math.random() * 100.0 <= chance) {
                enemy.func_70606_j(0.001f);
            }
        }
        if (WeaponAttributes.CRITICAL.hasAttribute(nbt) && WeaponAttributes.CRITICAL.rollChance()) {
            float bonus = (float)((double)dmgAmount * WeaponAttributes.CRITICAL.getCalculatedValue(nbt) / 100.0);
            event.setAmount(dmgAmount + bonus);
        }
        if (stack.func_77973_b() instanceof SwordItem && SwordAttribute.CHAINED.hasAttribute(nbt) && SwordAttribute.CHAINED.rollChance()) {
            double radius = SwordAttribute.CHAINED.getCalculatedValue(nbt);
            Vector3d pos = player.func_213303_ch();
            List entityList = enemy.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos.field_72450_a - radius, pos.field_72448_b - radius, pos.field_72449_c - radius, pos.field_72450_a + radius, pos.field_72448_b + radius, pos.field_72449_c + radius));
            for (LivingEntity entity : entityList) {
                if (entity instanceof PlayerEntity || entity instanceof AnimalEntity) continue;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), dmgAmount / 2.0f);
            }
        }
        if (stack.func_77973_b() instanceof ArmorItem && ArmorAttribute.MAGICAL.hasAttribute(nbt) && event.getSource().equals(DamageSource.field_76376_m)) {
            event.setAmount((float)((double)dmgAmount * ArmorAttribute.MAGICAL.getCalculatedValue(nbt) / 100.0));
        }
    }
}

