/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.architectury.event.events.TooltipEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class EventTooltip {
    public static void register() {
        TooltipEvent.ITEM.register((stack, lines, tooltipFlag) -> {
            CompoundNBT baseNbt = stack.func_196082_o();
            ItemType type = ItemUtil.type(stack.func_77973_b());
            if (type == null) {
                return;
            }
            NBTImpl nbt = NBTHelper.toCommon(baseNbt);
            Rarity rarity = Rarity.getRarity(nbt);
            if (rarity != Rarity.DEFAULT) {
                EventTooltip.addTooltips(lines, stack, baseNbt);
            }
        });
    }

    private static void addTooltips(List<ITextComponent> componentTooltip, ItemStack stack, CompoundNBT baseNbt) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        DecimalFormat format = new DecimalFormat("#.##");
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("");
        if (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof AxeItem) {
            Multimap attributesWeapon = stack.func_111283_C(EquipmentSlotType.MAINHAND);
            double damage = attributesWeapon.get((Object)Attributes.field_233823_f_).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
            double speed = attributesWeapon.get((Object)Attributes.field_233825_h_).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
            tooltip.add(TextFormatting.BLUE + "+" + format.format(damage) + " Damage");
            tooltip.add(TextFormatting.BLUE + "+" + format.format(speed + 4.0) + " Attack Speed");
        } else if (stack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
            EquipmentSlotType slot = armorItem.func_185083_B_();
            Multimap attributesArmor = stack.func_111283_C(slot);
            double armor = attributesArmor.get((Object)Attributes.field_233826_i_).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
            double armorToughness = attributesArmor.get((Object)Attributes.field_233827_j_).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
            tooltip.add(TextFormatting.BLUE + "+" + format.format(armor) + " Armor");
            tooltip.add(TextFormatting.BLUE + "+" + format.format(armorToughness) + " Armor Toughness");
        }
        if (!(stack.func_77973_b() instanceof ShieldItem) && !(stack.func_77973_b() instanceof BowItem)) {
            tooltip.add("");
        }
        tooltip.add(rarity.getDisplay(I18n::func_135052_a));
        Experience exp = new Experience(stack);
        tooltip.addAll(exp.displayExp(I18n::func_135052_a));
        if (baseNbt.func_74762_e("Unbreakable") == 1) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"levels.misc.durability.unlimited", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
        }
        tooltip.add("");
        long windowHandle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        boolean leftShift = InputMappings.func_216506_a((long)windowHandle, (int)340);
        boolean rightShift = InputMappings.func_216506_a((long)windowHandle, (int)344);
        if (!leftShift && !rightShift) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.attributes.shift", (Object[])new Object[0]));
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(StringTextComponent::new).collect(Collectors.toList()));
            return;
        }
        tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.attributes", (Object[])new Object[0]));
        ItemType type = ItemUtil.type(stack.func_77973_b());
        if (type == null) {
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(StringTextComponent::new).collect(Collectors.toList()));
            return;
        }
        tooltip.addAll(type.displayAttributes(nbt));
        componentTooltip.addAll(tooltip.stream().map(StringTextComponent::new).collect(Collectors.toList()));
    }
}

