/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import io.netty.buffer.Unpooled;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GuiTypeSelection
extends Screen {
    private Button[] attributeButtons;
    private final ItemType type;
    private final List<? extends AttributeBase> attributes;

    public GuiTypeSelection(ItemType type, List<? extends AttributeBase> attributes) {
        super((ITextComponent)new StringTextComponent("Attribute Selection"));
        this.type = type;
        this.attributes = attributes;
    }

    public void func_231160_c_() {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        CompoundNBT baseNbt = stack.func_196082_o();
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        this.attributeButtons = new Button[this.attributes.size()];
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            int maxLevel;
            AttributeBase attr = this.attributes.get(i);
            int tier = attr.getAttributeTier(nbt);
            String display = tier == (maxLevel = LevelConfigAttribute.getMaxLevel(attr)) ? attr.getBaseName() + " MAX" : attr.getCompleteName(tier + 1);
            this.attributeButtons[i] = new Button(this.field_230708_k_ / 2 - 147, 60 + i * 20, 75, 20, (ITextComponent)new StringTextComponent(display), this::actionPerformed, this::drawButtonTooltip);
            this.func_230480_a_((Widget)this.attributeButtons[i]);
            this.attributeButtons[i].field_230693_o_ = false;
        }
    }

    @Nullable
    private ItemStack getItemStack() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return null;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack == null) {
            return null;
        }
        ItemType currentType = ItemUtil.type(stack.func_77973_b());
        if (currentType != this.type) {
            return null;
        }
        return stack;
    }

    private void drawButtonTooltip(Button button, MatrixStack poseStack, int mouseX, int mouseY) {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.func_196082_o());
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (!button.equals(this.attributeButtons[i])) continue;
            AttributeBase attr = this.attributes.get(i);
            StringTextComponent cmp = new StringTextComponent("");
            attr.getUpgradeSummary(nbt, I18n::func_135052_a).stream().map(this::createComponent).forEach(arg_0 -> ((StringTextComponent)cmp).func_230529_a_(arg_0));
            this.func_238652_a_(poseStack, (ITextComponent)cmp, mouseX + 3, mouseY + 3);
        }
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        CompoundNBT baseNbt = stack.func_196082_o();
        ItemType currentType = ItemUtil.type(stack.func_77973_b());
        if (baseNbt == null || currentType != this.type) {
            return;
        }
        Experience exp = new Experience(stack);
        GuiTypeSelection.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"levels.misc.attributes", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        GuiTypeSelection.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"levels.misc.attributes.tokens", (Object[])new Object[0]) + ": " + exp.getAttributeTokens()), (int)(this.field_230708_k_ / 2 - 112), (int)40, (int)0xFFFFFF);
        GuiTypeSelection.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"levels.misc.attributes.current", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 112), (int)40, (int)0xFFFFFF);
        int k = -1;
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        for (AttributeBase attributeBase : this.attributes) {
            if (!attributeBase.hasAttribute(nbt)) continue;
            GuiTypeSelection.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)attributeBase.getName(nbt), (int)(this.field_230708_k_ / 2 + 112), (int)(60 + 10 * ++k), (int)attributeBase.getHexColor());
        }
        this.displayButtons(stack);
    }

    protected void actionPerformed(Button button) {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.func_77973_b());
        Experience exp = new Experience(stack);
        if (exp.getAttributeTokens() <= 0) {
            return;
        }
        if (currentType != this.type) {
            return;
        }
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (button != this.attributeButtons[i]) continue;
            PacketBuffer byteBuf = new PacketBuffer(Unpooled.buffer());
            byteBuf.writeInt(i);
            NetworkManager.sendToServer((ResourceLocation)PacketIdentifiers.ATTRIBUTE_SELECTION, (PacketBuffer)byteBuf);
        }
    }

    private void displayButtons(ItemStack stack) {
        Experience exp = new Experience(stack);
        int tokens = exp.getAttributeTokens();
        if (tokens <= 0) {
            for (Button attributeButton : this.attributeButtons) {
                attributeButton.field_230693_o_ = false;
            }
            return;
        }
        CompoundNBT nbtBase = stack.func_77978_p();
        NBTImpl nbt = NBTHelper.toCommon(nbtBase);
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            AttributeBase attribute = this.attributes.get(i);
            boolean hasAttribute = attribute.hasAttribute(nbt);
            boolean isMaxLevel = attribute.getAttributeTier(nbt) >= LevelConfigAttribute.getMaxLevel(attribute);
            int cost = attribute.getRarity().getCost();
            boolean shouldEnable = isMaxLevel ? false : (hasAttribute ? true : tokens >= cost);
            this.attributeButtons[i].field_230693_o_ = shouldEnable;
        }
    }

    private ITextComponent createComponent(String arg) {
        return new StringTextComponent(arg + "\n");
    }
}

