/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.leveling;

import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.common.leveling.exp.ExperienceEditor;
import com.thexfactor117.levels.common.leveling.exp.LevelUpProcessor;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.nbt.NBTType;
import lombok.Generated;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class Experience
implements ExperienceEditor {
    private final ItemStack stack;
    private final CompoundNBT nbt;
    private final INBT inbt;

    public Experience(ItemStack stack) {
        this.stack = stack;
        this.nbt = stack.func_196082_o();
        this.inbt = NBTHelper.toCommon(this.nbt);
    }

    @Override
    public INBT getNBT() {
        return this.inbt;
    }

    public class LevelUp
    implements LevelUpProcessor {
        private final PlayerEntity player;

        @Override
        public ExperienceEditor getExpEditor() {
            return Experience.this;
        }

        @Override
        public INBT getNBT() {
            return Experience.this.inbt;
        }

        @Override
        public void notifyLevelUp() {
            String message = Experience.this.stack.func_151000_E().getString() + TextFormatting.GRAY + " has leveled up to level " + TextFormatting.GOLD + Experience.this.getLevel() + TextFormatting.GRAY + "!";
            this.player.func_145747_a((ITextComponent)new StringTextComponent(message), Util.field_240973_b_);
        }

        @Override
        public boolean isWeapon() {
            return Experience.this.stack.func_77973_b() instanceof SwordItem || Experience.this.stack.func_77973_b() instanceof AxeItem;
        }

        @Override
        public void levelUpWeapon() {
            double multiplier = Experience.this.nbt.func_74769_h("Multiplier");
            ListNBT taglist = Experience.this.nbt.func_150295_c("AttributeModifiers", NBTType.COMPOUND.ordinal());
            CompoundNBT damageNbt = taglist.func_150305_b(0);
            CompoundNBT speedNbt = taglist.func_150305_b(1);
            double damageAmount = damageNbt.func_74769_h("Amount");
            double speedAmount = speedNbt.func_74769_h("Amount");
            double newDamage = damageAmount + damageAmount * multiplier / 2.0;
            double newSpeed = speedAmount - speedAmount * multiplier / 2.0;
            damageNbt.func_74780_a("Amount", newDamage);
            speedNbt.func_74780_a("Amount", newSpeed);
        }

        @Override
        public boolean isArmor() {
            return Experience.this.stack.func_77973_b() instanceof ArmorItem;
        }

        @Override
        public void levelUpArmor() {
            double multiplier = Experience.this.nbt.func_74769_h("Multiplier");
            ListNBT taglist = Experience.this.nbt.func_150295_c("AttributeModifiers", NBTType.COMPOUND.ordinal());
            CompoundNBT armorNbt = taglist.func_150305_b(0);
            CompoundNBT toughnessNbt = taglist.func_150305_b(1);
            double armorAmount = armorNbt.func_74769_h("Amount");
            double toughnessAmount = toughnessNbt.func_74769_h("Amount");
            double newArmor = armorAmount + armorAmount * multiplier / 2.0;
            double newToughness = toughnessAmount - toughnessAmount * multiplier / 2.0;
            armorNbt.func_74780_a("Amount", newArmor);
            toughnessNbt.func_74780_a("Amount", newToughness);
        }

        @Override
        public void saveEdits() {
            NBTHelper.saveStackNBT(Experience.this.stack, Experience.this.nbt);
        }

        @Generated
        public LevelUp(PlayerEntity player) {
            this.player = player;
        }
    }
}

