/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.network;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class PacketAttributeSelection {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PacketIdentifiers.ATTRIBUTE_SELECTION, (buffer, ctx) -> {
            boolean isEnough;
            PlayerEntity player = ctx.getPlayer();
            int index = buffer.readInt();
            if (player == null) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (stack == null) {
                return;
            }
            ItemType type = ItemUtil.type(stack.func_77973_b());
            if (type == null) {
                return;
            }
            CompoundNBT baseNbt = stack.func_196082_o();
            Experience exp = new Experience(stack);
            List<AttributeBase> attributeList = type.enabledAttributes();
            if (index < 0 || attributeList.size() <= index) {
                return;
            }
            AttributeBase attribute = attributeList.get(index);
            NBTImpl nbt = NBTHelper.toCommon(baseNbt);
            int maxLevel = LevelConfigAttribute.getMaxLevel(attribute);
            int newTier = attribute.getAttributeTier(nbt) + 1;
            int cost = attribute.hasAttribute(nbt) ? 1 : attribute.getRarity().getCost();
            boolean bl = isEnough = cost <= exp.getAttributeTokens();
            if (!isEnough || newTier > maxLevel) {
                return;
            }
            attribute.setAttributeTier(nbt, newTier);
            exp.addAttributeTokens(-cost);
            if (!attribute.hasAttribute(nbt) && AnyAttributes.UNBREAKABLE.equals(attribute)) {
                nbt.setInt("Unbreakable", 1);
            }
        });
    }
}

