/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;

public class AttackUtil {
    public static void processDeath(CompoundNBT nbt, ItemStack stack, LivingEntity enemy, PlayerEntity player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, true);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    public static void addExperience(ItemStack stack, LivingEntity enemy) {
        int xp;
        Experience exp = new Experience(stack);
        if (exp.isMaxLevel()) {
            return;
        }
        if (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof BowItem) {
            xp = (int)((double)enemy.func_110138_aP() * 0.2);
            exp.addExperience(xp);
        }
        if (stack.func_77973_b() instanceof ArmorItem || stack.func_77973_b() instanceof ShieldItem) {
            xp = 0;
            xp = enemy.func_110148_a(Attributes.field_233823_f_) != null ? (int)(enemy.func_233637_b_(Attributes.field_233823_f_) * 0.5) : (int)((double)enemy.func_110138_aP() * 0.5);
            exp.addExperience(xp);
        }
    }

    public static void useRarity(CompoundNBT nbt, ItemStack stack, boolean death) {
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (rarity == Rarity.DEFAULT) {
            return;
        }
        boolean isUnlimitedDurability = Configs.getInstance().main.getBoolean("unlimitedDurability");
        Experience exp = new Experience(stack);
        ItemType type = ItemUtil.type(stack.func_77973_b());
        if (type != null && death) {
            int addedXp = rarity.generateExperience();
            exp.addExperience(addedXp);
        }
        if (!isUnlimitedDurability && !death) {
            int repairDurability = rarity.generateRarityRepair();
            stack.func_196085_b(Math.max(stack.func_77952_i() - repairDurability, 0));
        }
    }

    public static void attemptLevel(CompoundNBT nbt, ItemStack stack, PlayerEntity player) {
        new Experience(stack).new Experience.LevelUp(player).levelUp();
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

