/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.MinecraftAttributes;
import com.thexfactor117.levels.common.leveling.Rarity;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;

public class WeaponHelper {
    public static void create(ItemStack stack, PlayerEntity player) {
        CompoundNBT baseNbt = stack.func_196082_o();
        if (baseNbt == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        Random rand = player.func_70681_au();
        if (rarity != Rarity.DEFAULT) {
            return;
        }
        Rarity rarityNew = Rarity.getRandomRarity(rand);
        rarityNew.setRarity(nbt);
        if (rarityNew == Rarity.MYTHIC) {
            player.func_184185_a(SoundEvents.field_187522_aL, 1.0f, 1.0f);
        }
        if (Configs.getInstance().main.getBoolean("unlimitedDurability")) {
            baseNbt.func_74768_a("Unbreakable", 1);
        }
        new Experience(stack).setLevel(1);
        baseNbt.func_74780_a("Multiplier", rarityNew.generateWeightedMultiplier());
        baseNbt.func_74768_a("HideFlags", 6);
        WeaponHelper.setAttributeModifiers(baseNbt, stack);
        NBTHelper.saveStackNBT(stack, baseNbt);
    }

    private static void setAttributeModifiers(CompoundNBT nbt, ItemStack stack) {
        Item item = stack.func_77973_b();
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (item instanceof SwordItem || item instanceof AxeItem) {
            Multimap map = item.func_111205_h(EquipmentSlotType.MAINHAND);
            Collection damageCollection = map.get((Object)Attributes.field_233823_f_);
            Collection speedCollection = map.get((Object)Attributes.field_233825_h_);
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            AttributeModifier speedModifier = (AttributeModifier)speedCollection.toArray()[0];
            double baseDamage = damageModifier.func_111164_d() + 1.0;
            double baseSpeed = speedModifier.func_111164_d();
            double damage = rarity.generateWeightedDamage(baseDamage);
            double speed = rarity.generateWeightedAttackSpeed(baseSpeed);
            AttributeModifier attackDamage = new AttributeModifier(MinecraftAttributes.ATTACK_DAMAGE_UUID, "attackDamage", damage, AttributeModifier.Operation.ADDITION);
            AttributeModifier attackSpeed = new AttributeModifier(MinecraftAttributes.ATTACK_SPEED_UUID, "attackSpeed", speed, AttributeModifier.Operation.ADDITION);
            stack.func_185129_a(Attributes.field_233823_f_, attackDamage, EquipmentSlotType.MAINHAND);
            stack.func_185129_a(Attributes.field_233825_h_, attackSpeed, EquipmentSlotType.MAINHAND);
        } else if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            EquipmentSlotType slot = armorItem.func_185083_B_();
            Multimap map = item.func_111205_h(slot);
            Collection armorCollection = map.get((Object)Attributes.field_233826_i_);
            Collection toughnessCollection = map.get((Object)Attributes.field_233827_j_);
            AttributeModifier armorModifier = (AttributeModifier)armorCollection.toArray()[0];
            AttributeModifier toughnessModifier = (AttributeModifier)toughnessCollection.toArray()[0];
            double baseArmor = armorModifier.func_111164_d();
            double baseToughness = toughnessModifier.func_111164_d();
            double newArmor = rarity.getWeightedArmor(baseArmor);
            double newToughness = rarity.generateWeightedArmorToughness(baseToughness);
            AttributeModifier armor = new AttributeModifier(MinecraftAttributes.ARMOR_UUID, "armor", newArmor, AttributeModifier.Operation.ADDITION);
            AttributeModifier toughness = new AttributeModifier(MinecraftAttributes.ARMOR_TOUGHNESS_UUID, "armorToughness", newToughness, AttributeModifier.Operation.ADDITION);
            stack.func_185129_a(Attributes.field_233826_i_, armor, slot);
            stack.func_185129_a(Attributes.field_233827_j_, toughness, slot);
        }
    }
}

