/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling;

import com.thexfactor117.levels.common.collections.RandomCollection;
import com.thexfactor117.levels.common.color.LegacyTextColor;
import com.thexfactor117.levels.common.leveling.attributes.display.Formatter;
import com.thexfactor117.levels.common.nbt.INBT;
import java.util.Random;
import lombok.Generated;

public enum Rarity {
    DEFAULT(LegacyTextColor.GRAY, 0.0, 0, 0),
    COMMON(LegacyTextColor.WHITE, 0.65, -267386864, 0x50FFFFFF),
    UNCOMMON(LegacyTextColor.DARK_GREEN, 0.2, -267386864, 0x5000AA00),
    RARE(LegacyTextColor.AQUA, 0.1, -267386864, 0x5055FFFF),
    LEGENDARY(LegacyTextColor.DARK_PURPLE, 0.045, -267386864, 0x50AA00AA),
    MYTHIC(LegacyTextColor.GOLD, 0.005, -267386864, 1358932480);

    public static final RandomCollection<Rarity> RARITY_RANDOM;
    public static final String RARITY_KEY = "levels:rarity";
    private final String color;
    private final int hex;
    private final double defaultChance;
    private final int backgroundColor;
    private final int borderColor;

    private Rarity(LegacyTextColor color, double chance, int backgroundColor, int borderColor) {
        this.color = color.toString();
        this.hex = color.getHex();
        this.defaultChance = chance;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    public String getDisplay(Formatter formatter) {
        return this.color + (Object)((Object)LegacyTextColor.Style.ITALIC) + formatter.format("levels.rarities." + this.ordinal(), new String[0]);
    }

    public static Rarity getRandomRarity(Random rand) {
        return RARITY_RANDOM.next(rand);
    }

    public static Rarity getRarity(INBT nbt) {
        return nbt != null && nbt.hasKey(RARITY_KEY) ? Rarity.values()[nbt.getInt(RARITY_KEY)] : DEFAULT;
    }

    public void setRarity(INBT nbt) {
        if (nbt != null) {
            nbt.setInt(RARITY_KEY, this.ordinal());
        }
    }

    public int generateExperience() {
        if (this == DEFAULT) {
            return 0;
        }
        switch (this) {
            case UNCOMMON: {
                int chanceRoll = (int)(Math.random() * 15.0);
                int xp = (int)(Math.random() * 3.0 + 1.0);
                return chanceRoll == 0 ? xp : 0;
            }
            case RARE: {
                int chanceRoll = (int)(Math.random() * 10.0);
                int xp = (int)(Math.random() * 5.0 + 1.0);
                return chanceRoll == 0 ? xp : 0;
            }
            case LEGENDARY: {
                int chanceRoll = (int)(Math.random() * 7.0);
                int xp = (int)(Math.random() * 5.0 + 3.0);
                return chanceRoll == 0 ? xp : 0;
            }
            case MYTHIC: {
                int chanceRoll = (int)(Math.random() * 5.0);
                int xp = (int)(Math.random() * 8.0 + 3.0);
                return chanceRoll == 0 ? xp : 0;
            }
        }
        return 0;
    }

    public int generateRarityRepair() {
        if (this == DEFAULT) {
            return 0;
        }
        switch (this) {
            case UNCOMMON: {
                int chanceRoll = (int)(Math.random() * 15.0);
                return chanceRoll == 0 ? 1 : 0;
            }
            case RARE: {
                int chanceRoll = (int)(Math.random() * 10.0);
                int repair = (int)(Math.random() * 2.0);
                return chanceRoll == 0 ? 1 + repair : 0;
            }
            case LEGENDARY: {
                int chanceRoll = (int)(Math.random() * 7.0);
                int repair = (int)(Math.random() * 3.0 + 1.0);
                return chanceRoll == 0 ? 1 + repair : 0;
            }
            case MYTHIC: {
                int chanceRoll = (int)(Math.random() * 5.0);
                int repair = (int)(Math.random() * 5.0 + 1.0);
                return chanceRoll == 0 ? 1 + repair : 0;
            }
        }
        return 0;
    }

    public double generateWeightedDamage(double baseDamage) {
        if (this == DEFAULT) {
            return baseDamage;
        }
        int range = this.ordinal() + 2;
        int addAttackBase = this.ordinal() - 3;
        return Math.random() * (double)range + (baseDamage + (double)addAttackBase);
    }

    public double generateWeightedAttackSpeed(double baseAttackSpeed) {
        if (this == DEFAULT) {
            return baseAttackSpeed;
        }
        double ordinalDouble = this.ordinal();
        double range = (ordinalDouble + 1.0) / 10.0;
        double addAttackSpeed = (ordinalDouble - 3.0) / 10.0;
        return Math.random() * range + (baseAttackSpeed + addAttackSpeed);
    }

    public double generateWeightedArmorToughness(double baseToughness) {
        double result = this.generateWeightedAttackSpeed(baseToughness);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public double getWeightedArmor(double baseArmor) {
        return this.generateWeightedArmorToughness(baseArmor);
    }

    public double generateWeightedMultiplier() {
        double x = this.ordinal() - 1;
        double range = 0.499 + 0.0235 * x + 0.0064 * Math.pow(x, 2.0) + 8.0E-4 * Math.pow(x, 3.0);
        return Math.random() * range;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public int getHex() {
        return this.hex;
    }

    @Generated
    public double getDefaultChance() {
        return this.defaultChance;
    }

    @Generated
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public int getBorderColor() {
        return this.borderColor;
    }

    static {
        RARITY_RANDOM = new RandomCollection();
        for (Rarity entry : Rarity.values()) {
            if (entry == DEFAULT) continue;
            RARITY_RANDOM.add(entry.defaultChance, entry);
        }
    }
}

