/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    public static void saveFile(Map<String, String> toSave, File file) {
        Properties properties = new Properties();
        properties.putAll(toSave);
        try (FileWriter writer = new FileWriter(file);){
            properties.store(writer, "Saved Config");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> loadFile(File file) {
        if (!file.exists()) {
            return new HashMap<String, String>();
        }
        Properties properties = new Properties();
        try {
            FileReader reader = new FileReader(file);
            Object object = null;
            try {
                properties.load(reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }
}

