/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.thexfactor117.levels.architectury.events.custom.AttackCallback;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.AttackUtil;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.ArmorAttribute;
import com.thexfactor117.levels.common.leveling.attributes.BowAttribute;
import com.thexfactor117.levels.common.leveling.attributes.SwordAttribute;
import com.thexfactor117.levels.common.leveling.attributes.WeaponAttributes;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EventAttack {
    public static void register() {
        AttackCallback.EVENT.register(event -> {
            Entity source = event.getSource().m_7640_();
            LivingEntity victim = event.getVictim();
            if (source == null) {
                return;
            }
            if (source instanceof Player) {
                Player player = (Player)source;
                LivingEntity enemy = victim;
                ItemStack stack = player.m_21205_();
                CompoundTag nbt = stack.m_41784_();
                if (nbt != null && stack.m_41720_() instanceof SwordItem) {
                    EventAttack.processHit(event, nbt, stack, enemy, player);
                }
            } else if (source instanceof LivingEntity && victim instanceof Player) {
                Player player = (Player)victim;
                LivingEntity enemy = (LivingEntity)source;
                EventAttack.processArmorHit(event, player, enemy);
            } else if (source instanceof Arrow) {
                Arrow arrow = (Arrow)source;
                Entity shooter = arrow.m_19749_();
                if (shooter == null) {
                    return;
                }
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    LivingEntity enemy = victim;
                    ItemStack stack = player.m_21205_();
                    CompoundTag nbt = stack.m_41784_();
                    if (enemy != null && nbt != null && stack.m_41720_() instanceof BowItem) {
                        EventAttack.processHit(event, nbt, stack, enemy, player);
                    }
                } else if (shooter instanceof LivingEntity) {
                    Player player = (Player)victim;
                    LivingEntity enemy = (LivingEntity)shooter;
                    if (player != null) {
                        EventAttack.processArmorHit(event, player, enemy);
                    }
                }
            }
        });
        EntityEvent.LIVING_DEATH.register((living, dmgSource) -> {
            Entity source = dmgSource.m_7640_();
            if (source == null) {
                return EventResult.pass();
            }
            if (source instanceof Player) {
                Player player = (Player)source;
                LivingEntity enemy = living;
                ItemStack stack = player.m_21205_();
                CompoundTag nbt = stack.m_41784_();
                if (enemy != null && nbt != null && stack.m_41720_() instanceof SwordItem) {
                    AttackUtil.processDeath(nbt, stack, enemy, player);
                }
            } else if (source instanceof Arrow) {
                Arrow arrow = (Arrow)source;
                Entity shooter = arrow.m_19749_();
                if (shooter == null) {
                    return EventResult.pass();
                }
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    LivingEntity enemy = living;
                    ItemStack stack = player.m_21205_();
                    CompoundTag nbt = stack.m_41784_();
                    if (enemy != null && nbt != null && stack.m_41720_() instanceof BowItem) {
                        AttackUtil.processDeath(nbt, stack, enemy, player);
                        NBTImpl inbt = NBTHelper.toCommon(nbt);
                        if (BowAttribute.RECOVER.hasAttribute(inbt)) {
                            enemy.m_20000_((ItemLike)Items.f_42412_, (int)(Math.random() * 2.0));
                        }
                    }
                }
            }
            return EventResult.pass();
        });
    }

    private static void processArmorHit(AttackCallback.AttackInstance event, Player player, LivingEntity enemy) {
        CompoundTag nbt;
        for (ItemStack stack : player.m_150109_().f_35975_) {
            CompoundTag nbt2 = stack.m_41784_();
            if (!(stack.m_41720_() instanceof ArmorItem)) continue;
            EventAttack.processHit(event, nbt2, stack, enemy, player);
        }
        ItemStack shield = (ItemStack)player.m_150109_().f_35976_.get(0);
        if (shield.m_41720_() instanceof ShieldItem && (nbt = shield.m_41784_()) != null && player.m_7655_() == InteractionHand.OFF_HAND) {
            EventAttack.processHit(event, nbt, shield, enemy, player);
        }
    }

    private static void processHit(AttackCallback.AttackInstance event, CompoundTag nbt, ItemStack stack, LivingEntity enemy, Player player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, false);
        EventAttack.useAttributes(nbt, event, stack, player, enemy);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    private static void useAttributes(CompoundTag baseNbt, AttackCallback.AttackInstance event, ItemStack stack, Player player, LivingEntity enemy) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        if (AnyAttributes.FIRE.hasAttribute(nbt) && AnyAttributes.FIRE.rollChance()) {
            enemy.m_20254_((int)AnyAttributes.FIRE.getCalculatedValue(nbt));
        }
        if (AnyAttributes.FROST.hasAttribute(nbt) && AnyAttributes.FROST.rollChance()) {
            enemy.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)AnyAttributes.FROST.getCalculatedValue(nbt), 10));
        }
        if (AnyAttributes.POISON.hasAttribute(nbt) && AnyAttributes.POISON.rollChance()) {
            enemy.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (int)AnyAttributes.POISON.getCalculatedValue(nbt), AnyAttributes.POISON.getAttributeTier(nbt)));
        }
        if (AnyAttributes.DURABLE.hasAttribute(nbt) && AnyAttributes.DURABLE.rollChance()) {
            stack.m_41721_(stack.m_41773_() - (int)AnyAttributes.DURABLE.getCalculatedValue(nbt));
        }
        float dmgAmount = event.getAmount();
        if (WeaponAttributes.ABSORB.hasAttribute(nbt) && WeaponAttributes.ABSORB.rollChance()) {
            float regenAmount = (float)((double)dmgAmount * WeaponAttributes.ABSORB.getCalculatedValue(nbt) / 100.0);
            player.m_21153_(player.m_21223_() + regenAmount);
        }
        if (WeaponAttributes.VOID.hasAttribute(nbt)) {
            double chance = WeaponAttributes.VOID.getCalculatedValue(nbt);
            if (Math.random() * 100.0 <= chance) {
                enemy.m_21153_(0.001f);
            }
        }
        if (WeaponAttributes.CRITICAL.hasAttribute(nbt) && WeaponAttributes.CRITICAL.rollChance()) {
            float bonus = (float)((double)dmgAmount * WeaponAttributes.CRITICAL.getCalculatedValue(nbt) / 100.0);
            event.setAmount(dmgAmount + bonus);
        }
        if (stack.m_41720_() instanceof SwordItem && SwordAttribute.CHAINED.hasAttribute(nbt) && SwordAttribute.CHAINED.rollChance()) {
            double radius = SwordAttribute.CHAINED.getCalculatedValue(nbt);
            Vec3 pos = player.m_20182_();
            List entityList = enemy.m_9236_().m_45976_(LivingEntity.class, new AABB(pos.f_82479_ - radius, pos.f_82480_ - radius, pos.f_82481_ - radius, pos.f_82479_ + radius, pos.f_82480_ + radius, pos.f_82481_ + radius));
            for (LivingEntity entity : entityList) {
                if (entity instanceof Player || entity instanceof Animal) continue;
                entity.m_6469_(player.m_9236_().m_269111_().m_269075_(player), dmgAmount / 2.0f);
            }
        }
        if (stack.m_41720_() instanceof ArmorItem && ArmorAttribute.MAGICAL.hasAttribute(nbt) && event.getSource().m_276093_(DamageTypes.f_268515_)) {
            event.setAmount((float)((double)dmgAmount * ArmorAttribute.MAGICAL.getCalculatedValue(nbt) / 100.0));
        }
    }
}

