/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.events;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import dev.architectury.event.events.client.ClientTooltipEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;

public class EventTooltip {
    public static void register() {
        ClientTooltipEvent.ITEM.register((stack, lines, tooltipFlag) -> {
            CompoundTag baseNbt = stack.m_41784_();
            ItemType type = ItemUtil.type(stack.m_41720_());
            if (type == null) {
                return;
            }
            NBTImpl nbt = NBTHelper.toCommon(baseNbt);
            Rarity rarity = Rarity.getRarity(nbt);
            if (rarity != Rarity.DEFAULT) {
                EventTooltip.addTooltips(lines, stack, baseNbt);
            }
        });
    }

    private static void addTooltips(List<Component> componentTooltip, ItemStack stack, CompoundTag baseNbt) {
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        DecimalFormat format = new DecimalFormat("#.##");
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("");
        if (stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem) {
            Multimap attributesWeapon = stack.m_41638_(EquipmentSlot.MAINHAND);
            double damage = attributesWeapon.get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            double speed = attributesWeapon.get((Object)Attributes.f_22283_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            tooltip.add(ChatFormatting.BLUE + "+" + format.format(damage) + " Damage");
            tooltip.add(ChatFormatting.BLUE + "+" + format.format(speed + 4.0) + " Attack Speed");
        } else if (stack.m_41720_() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)stack.m_41720_();
            EquipmentSlot slot = armorItem.m_40402_();
            Multimap attributesArmor = stack.m_41638_(slot);
            double armor = attributesArmor.get((Object)Attributes.f_22284_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            double armorToughness = attributesArmor.get((Object)Attributes.f_22285_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            tooltip.add(ChatFormatting.BLUE + "+" + format.format(armor) + " Armor");
            tooltip.add(ChatFormatting.BLUE + "+" + format.format(armorToughness) + " Armor Toughness");
        }
        if (!(stack.m_41720_() instanceof ShieldItem) && !(stack.m_41720_() instanceof BowItem)) {
            tooltip.add("");
        }
        tooltip.add(rarity.getDisplay(I18n::m_118938_));
        Experience exp = new Experience(stack);
        tooltip.addAll(exp.displayExp(I18n::m_118938_));
        if (baseNbt.m_128451_("Unbreakable") == 1) {
            tooltip.add(ChatFormatting.GRAY + I18n.m_118938_((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"levels.misc.durability.unlimited", (Object[])new Object[0]));
        } else {
            tooltip.add(ChatFormatting.GRAY + I18n.m_118938_((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + (stack.m_41776_() - stack.m_41773_()) + " / " + stack.m_41776_());
        }
        tooltip.add("");
        long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean leftShift = InputConstants.m_84830_((long)windowHandle, (int)340);
        boolean rightShift = InputConstants.m_84830_((long)windowHandle, (int)344);
        if (!leftShift && !rightShift) {
            tooltip.add(ChatFormatting.GRAY + "" + ChatFormatting.ITALIC + I18n.m_118938_((String)"levels.misc.attributes.shift", (Object[])new Object[0]));
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(Component::m_237113_).collect(Collectors.toList()));
            return;
        }
        tooltip.add(ChatFormatting.GRAY + "" + ChatFormatting.ITALIC + I18n.m_118938_((String)"levels.misc.attributes", (Object[])new Object[0]));
        ItemType type = ItemUtil.type(stack.m_41720_());
        if (type == null) {
            tooltip.add("");
            componentTooltip.addAll(tooltip.stream().map(Component::m_237113_).collect(Collectors.toList()));
            return;
        }
        tooltip.addAll(type.displayAttributes(nbt));
        componentTooltip.addAll(tooltip.stream().map(Component::m_237113_).collect(Collectors.toList()));
    }
}

