/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.gui;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.GuiTypeRequest;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.exp.ExperienceEditor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiItemInformation
extends Screen {
    private Button selection;

    public GuiItemInformation() {
        super((Component)Component.m_237113_((String)"Item Information"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7856_() {
        this.selection = Button.m_253074_((Component)Component.m_237113_((String)"Attribute Selection"), this::actionPerformed).m_252987_(this.f_96543_ / 2 - 166, 125, 110, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.selection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.m_41720_());
        if (currentType == null) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        this.drawStrings(guiGraphics, stack, nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void actionPerformed(Button button) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.m_41720_());
        if (currentType == null) {
            return;
        }
        if (button != this.selection) {
            return;
        }
        new GuiTypeRequest(currentType).send();
    }

    private void drawStrings(GuiGraphics guiGraphics, ItemStack stack, CompoundTag nbt) {
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        Experience exp = new Experience(stack);
        guiGraphics.m_280653_(this.f_96547_, stack.m_41611_(), this.f_96543_ / 2, 20, rarity.getHex());
        guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"levels.misc.rarity", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)("levels.rarities." + rarity.ordinal()), (Object[])new Object[0]), this.f_96543_ / 2 - 50, 40, rarity.getHex());
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes", (Object[])new Object[0]), this.f_96543_ / 2, 80, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes.tokens", (Object[])new Object[0]) + ": " + exp.getAttributeTokens(), this.f_96543_ / 2 - 112, 100, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes.current", (Object[])new Object[0]), this.f_96543_ / 2 + 112, 100, 0xFFFFFF);
        if (exp.isMaxLevel()) {
            guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"levels.misc.level", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"levels.misc.max", (Object[])new Object[0]), this.f_96543_ / 2 - 50, 50, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"levels.misc.max", (Object[])new Object[0]), this.f_96543_ / 2 - 50, 60, 0xFFFFFF);
        } else {
            guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"levels.misc.level", (Object[])new Object[0]) + ": " + exp.getLevel(), this.f_96543_ / 2 - 50, 50, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + exp.getExperience() + " / " + ExperienceEditor.getNextLevelExperience(exp.getLevel()), this.f_96543_ / 2 - 50, 60, 0xFFFFFF);
        }
        int k = -1;
        ItemType type = ItemUtil.type(stack.m_41720_());
        if (type == null) {
            return;
        }
        List<AttributeBase> attributes = type.enabledAttributes();
        for (AttributeBase attribute : attributes) {
            if (!attribute.hasAttribute(inbt)) continue;
            guiGraphics.m_280137_(this.f_96547_, attribute.getName(inbt), this.f_96543_ / 2 + 112, 115 + 10 * ++k, attribute.getHexColor());
        }
    }
}

