/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.gui;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GuiTypeSelection
extends Screen {
    private Button[] attributeButtons;
    private final ItemType type;
    private final List<? extends AttributeBase> attributes;

    public GuiTypeSelection(ItemType type, List<? extends AttributeBase> attributes) {
        super((Component)Component.m_237113_((String)"Attribute Selection"));
        this.type = type;
        this.attributes = attributes;
    }

    public void m_7856_() {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        CompoundTag baseNbt = stack.m_41784_();
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        this.attributeButtons = new Button[this.attributes.size()];
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            int maxLevel;
            AttributeBase attr = this.attributes.get(i);
            int tier = attr.getAttributeTier(nbt);
            String display = tier == (maxLevel = LevelConfigAttribute.getMaxLevel(attr)) ? attr.getBaseName() + " MAX" : attr.getCompleteName(tier + 1);
            this.attributeButtons[i] = Button.m_253074_((Component)Component.m_237113_((String)display), this::actionPerformed).m_252987_(this.f_96543_ / 2 - 147, 60 + i * 20, 75, 20).m_257505_(this.getTooltipLines(i)).m_253136_();
            this.m_142416_((GuiEventListener)this.attributeButtons[i]);
            this.attributeButtons[i].f_93623_ = false;
        }
    }

    @Nullable
    private ItemStack getItemStack() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        ItemStack stack = player.m_21205_();
        if (stack == null) {
            return null;
        }
        ItemType currentType = ItemUtil.type(stack.m_41720_());
        if (currentType != this.type) {
            return null;
        }
        return stack;
    }

    private void drawButtonTooltip(Button button, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.m_41784_());
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (!button.equals(this.attributeButtons[i])) continue;
            AttributeBase attr = this.attributes.get(i);
            MutableComponent cmp = Component.m_237119_();
            attr.getUpgradeSummary(nbt, I18n::m_118938_).stream().map(this::createComponent).forEach(arg_0 -> ((MutableComponent)cmp).m_7220_(arg_0));
            guiGraphics.m_280557_(this.f_96547_, (Component)cmp, mouseX + 3, mouseY + 3);
        }
    }

    private Tooltip getTooltipLines(int pos) {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return Tooltip.m_257550_((Component)Component.m_237119_());
        }
        NBTImpl nbt = NBTHelper.toCommon(stack.m_41784_());
        AttributeBase attr = this.attributes.get(pos);
        MutableComponent cmp = Component.m_237113_((String)"");
        attr.getUpgradeSummary(nbt, I18n::m_118938_).stream().map(this::createComponent).forEach(arg_0 -> ((MutableComponent)cmp).m_7220_(arg_0));
        return Tooltip.m_257550_((Component)cmp);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        CompoundTag baseNbt = stack.m_41784_();
        ItemType currentType = ItemUtil.type(stack.m_41720_());
        if (baseNbt == null || currentType != this.type) {
            return;
        }
        Experience exp = new Experience(stack);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes", (Object[])new Object[0]), this.f_96543_ / 2, 20, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes.tokens", (Object[])new Object[0]) + ": " + exp.getAttributeTokens(), this.f_96543_ / 2 - 112, 40, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"levels.misc.attributes.current", (Object[])new Object[0]), this.f_96543_ / 2 + 112, 40, 0xFFFFFF);
        int k = -1;
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        for (AttributeBase attributeBase : this.attributes) {
            if (!attributeBase.hasAttribute(nbt)) continue;
            guiGraphics.m_280137_(this.f_96547_, attributeBase.getName(nbt), this.f_96543_ / 2 + 112, 60 + 10 * ++k, attributeBase.getHexColor());
        }
        this.displayButtons(stack);
    }

    protected void actionPerformed(Button button) {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return;
        }
        ItemType currentType = ItemUtil.type(stack.m_41720_());
        Experience exp = new Experience(stack);
        if (exp.getAttributeTokens() <= 0) {
            return;
        }
        if (currentType != this.type) {
            return;
        }
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            if (button != this.attributeButtons[i]) continue;
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            byteBuf.writeInt(i);
            NetworkManager.sendToServer((ResourceLocation)PacketIdentifiers.ATTRIBUTE_SELECTION, (FriendlyByteBuf)byteBuf);
        }
    }

    private void displayButtons(ItemStack stack) {
        Experience exp = new Experience(stack);
        int tokens = exp.getAttributeTokens();
        if (tokens <= 0) {
            for (Button attributeButton : this.attributeButtons) {
                attributeButton.f_93623_ = false;
            }
            return;
        }
        CompoundTag nbtBase = stack.m_41783_();
        NBTImpl nbt = NBTHelper.toCommon(nbtBase);
        for (int i = 0; i < this.attributeButtons.length; ++i) {
            AttributeBase attribute = this.attributes.get(i);
            boolean hasAttribute = attribute.hasAttribute(nbt);
            boolean isMaxLevel = attribute.getAttributeTier(nbt) >= LevelConfigAttribute.getMaxLevel(attribute);
            int cost = attribute.getRarity().getCost();
            boolean shouldEnable = isMaxLevel ? false : (hasAttribute ? true : tokens >= cost);
            this.attributeButtons[i].f_93623_ = shouldEnable;
        }
    }

    private Component createComponent(String arg) {
        return Component.m_237113_((String)(arg + "\n"));
    }
}

