/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.leveling;

import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.common.leveling.exp.ExperienceEditor;
import com.thexfactor117.levels.common.leveling.exp.LevelUpProcessor;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.nbt.NBTType;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class Experience
implements ExperienceEditor {
    private final ItemStack stack;
    private final CompoundTag nbt;
    private final INBT inbt;

    public Experience(ItemStack stack) {
        this.stack = stack;
        this.nbt = stack.m_41784_();
        this.inbt = NBTHelper.toCommon(this.nbt);
    }

    @Override
    public INBT getNBT() {
        return this.inbt;
    }

    public class LevelUp
    implements LevelUpProcessor {
        private final Player player;

        @Override
        public ExperienceEditor getExpEditor() {
            return Experience.this;
        }

        @Override
        public INBT getNBT() {
            return Experience.this.inbt;
        }

        @Override
        public void notifyLevelUp() {
            String message = Experience.this.stack.m_41611_().getString() + ChatFormatting.GRAY + " has leveled up to level " + ChatFormatting.GOLD + Experience.this.getLevel() + ChatFormatting.GRAY + "!";
            this.player.m_213846_((Component)Component.m_237113_((String)message));
        }

        @Override
        public boolean isWeapon() {
            return Experience.this.stack.m_41720_() instanceof SwordItem || Experience.this.stack.m_41720_() instanceof AxeItem;
        }

        @Override
        public void levelUpWeapon() {
            double multiplier = Experience.this.nbt.m_128459_("Multiplier");
            ListTag taglist = Experience.this.nbt.m_128437_("AttributeModifiers", NBTType.COMPOUND.ordinal());
            CompoundTag damageNbt = taglist.m_128728_(0);
            CompoundTag speedNbt = taglist.m_128728_(1);
            double damageAmount = damageNbt.m_128459_("Amount");
            double speedAmount = speedNbt.m_128459_("Amount");
            double newDamage = damageAmount + damageAmount * multiplier / 2.0;
            double newSpeed = speedAmount - speedAmount * multiplier / 2.0;
            damageNbt.m_128347_("Amount", newDamage);
            speedNbt.m_128347_("Amount", newSpeed);
        }

        @Override
        public boolean isArmor() {
            return Experience.this.stack.m_41720_() instanceof ArmorItem;
        }

        @Override
        public void levelUpArmor() {
            double multiplier = Experience.this.nbt.m_128459_("Multiplier");
            ListTag taglist = Experience.this.nbt.m_128437_("AttributeModifiers", NBTType.COMPOUND.ordinal());
            CompoundTag armorNbt = taglist.m_128728_(0);
            CompoundTag toughnessNbt = taglist.m_128728_(1);
            double armorAmount = armorNbt.m_128459_("Amount");
            double toughnessAmount = toughnessNbt.m_128459_("Amount");
            double newArmor = armorAmount + armorAmount * multiplier / 2.0;
            double newToughness = toughnessAmount - toughnessAmount * multiplier / 2.0;
            armorNbt.m_128347_("Amount", newArmor);
            toughnessNbt.m_128347_("Amount", newToughness);
        }

        @Override
        public void saveEdits() {
            NBTHelper.saveStackNBT(Experience.this.stack, Experience.this.nbt);
        }

        @Generated
        public LevelUp(Player player) {
            this.player = player;
        }
    }
}

