/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.network;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.network.PacketIdentifiers;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PacketAttributeSelection {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PacketIdentifiers.ATTRIBUTE_SELECTION, (buffer, ctx) -> {
            boolean isEnough;
            Player player = ctx.getPlayer();
            int index = buffer.readInt();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (stack == null) {
                return;
            }
            ItemType type = ItemUtil.type(stack.m_41720_());
            if (type == null) {
                return;
            }
            CompoundTag baseNbt = stack.m_41784_();
            Experience exp = new Experience(stack);
            List<AttributeBase> attributeList = type.enabledAttributes();
            if (index < 0 || attributeList.size() <= index) {
                return;
            }
            AttributeBase attribute = attributeList.get(index);
            NBTImpl nbt = NBTHelper.toCommon(baseNbt);
            int maxLevel = LevelConfigAttribute.getMaxLevel(attribute);
            int newTier = attribute.getAttributeTier(nbt) + 1;
            int cost = attribute.hasAttribute(nbt) ? 1 : attribute.getRarity().getCost();
            boolean bl = isEnough = cost <= exp.getAttributeTokens();
            if (!isEnough || newTier > maxLevel) {
                return;
            }
            attribute.setAttributeTier(nbt, newTier);
            exp.addAttributeTokens(-cost);
            if (!attribute.hasAttribute(nbt) && AnyAttributes.UNBREAKABLE.equals(attribute)) {
                nbt.setInt("Unbreakable", 1);
            }
        });
    }
}

