/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.architectury.util.ItemUtil;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;

public class AttackUtil {
    public static void processDeath(CompoundTag nbt, ItemStack stack, LivingEntity enemy, Player player) {
        AttackUtil.addExperience(stack, enemy);
        AttackUtil.useRarity(nbt, stack, true);
        AttackUtil.attemptLevel(nbt, stack, player);
    }

    public static void addExperience(ItemStack stack, LivingEntity enemy) {
        int xp;
        Experience exp = new Experience(stack);
        if (exp.isMaxLevel()) {
            return;
        }
        if (stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof BowItem) {
            xp = (int)((double)enemy.m_21233_() * 0.2);
            exp.addExperience(xp);
        }
        if (stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof ShieldItem) {
            xp = 0;
            xp = enemy.m_21051_(Attributes.f_22281_) != null ? (int)(enemy.m_21133_(Attributes.f_22281_) * 0.5) : (int)((double)enemy.m_21233_() * 0.5);
            exp.addExperience(xp);
        }
    }

    public static void useRarity(CompoundTag nbt, ItemStack stack, boolean death) {
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (rarity == Rarity.DEFAULT) {
            return;
        }
        boolean isUnlimitedDurability = Configs.getInstance().main.getBoolean("unlimitedDurability");
        Experience exp = new Experience(stack);
        ItemType type = ItemUtil.type(stack.m_41720_());
        if (type != null && death) {
            int addedXp = rarity.generateExperience();
            exp.addExperience(addedXp);
        }
        if (!isUnlimitedDurability && !death) {
            int repairDurability = rarity.generateRarityRepair();
            stack.m_41721_(Math.max(stack.m_41773_() - repairDurability, 0));
        }
    }

    public static void attemptLevel(CompoundTag nbt, ItemStack stack, Player player) {
        new Experience(stack).new Experience.LevelUp(player).levelUp();
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

