/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.architectury.util;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.architectury.leveling.Experience;
import com.thexfactor117.levels.architectury.nbt.NBTHelper;
import com.thexfactor117.levels.architectury.nbt.NBTImpl;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.MinecraftAttributes;
import com.thexfactor117.levels.common.leveling.Rarity;
import java.util.Collection;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class WeaponHelper {
    private static final Random RND = new Random();

    public static void create(ItemStack stack, Player player) {
        CompoundTag baseNbt = stack.m_41784_();
        if (baseNbt == null) {
            return;
        }
        NBTImpl nbt = NBTHelper.toCommon(baseNbt);
        Rarity rarity = Rarity.getRarity(nbt);
        if (rarity != Rarity.DEFAULT) {
            return;
        }
        Rarity rarityNew = Rarity.getRandomRarity(RND);
        rarityNew.setRarity(nbt);
        if (rarityNew == Rarity.MYTHIC) {
            player.m_5496_(SoundEvents.f_11891_, 1.0f, 1.0f);
        }
        if (Configs.getInstance().main.getBoolean("unlimitedDurability")) {
            baseNbt.m_128405_("Unbreakable", 1);
        }
        new Experience(stack).setLevel(1);
        baseNbt.m_128347_("Multiplier", rarityNew.generateWeightedMultiplier());
        baseNbt.m_128405_("HideFlags", 6);
        WeaponHelper.setAttributeModifiers(baseNbt, stack);
        NBTHelper.saveStackNBT(stack, baseNbt);
    }

    private static void setAttributeModifiers(CompoundTag nbt, ItemStack stack) {
        Item item = stack.m_41720_();
        NBTImpl inbt = NBTHelper.toCommon(nbt);
        Rarity rarity = Rarity.getRarity(inbt);
        if (item instanceof SwordItem || item instanceof AxeItem) {
            Multimap map = item.m_7167_(EquipmentSlot.MAINHAND);
            Collection damageCollection = map.get((Object)Attributes.f_22281_);
            Collection speedCollection = map.get((Object)Attributes.f_22283_);
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            AttributeModifier speedModifier = (AttributeModifier)speedCollection.toArray()[0];
            double baseDamage = damageModifier.m_22218_() + 1.0;
            double baseSpeed = speedModifier.m_22218_();
            double damage = rarity.generateWeightedDamage(baseDamage);
            double speed = rarity.generateWeightedAttackSpeed(baseSpeed);
            AttributeModifier attackDamage = new AttributeModifier(MinecraftAttributes.ATTACK_DAMAGE_UUID, "attackDamage", damage, AttributeModifier.Operation.ADDITION);
            AttributeModifier attackSpeed = new AttributeModifier(MinecraftAttributes.ATTACK_SPEED_UUID, "attackSpeed", speed, AttributeModifier.Operation.ADDITION);
            stack.m_41643_(Attributes.f_22281_, attackDamage, EquipmentSlot.MAINHAND);
            stack.m_41643_(Attributes.f_22283_, attackSpeed, EquipmentSlot.MAINHAND);
        } else if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            EquipmentSlot slot = armorItem.m_40402_();
            Multimap map = item.m_7167_(slot);
            Collection armorCollection = map.get((Object)Attributes.f_22284_);
            Collection toughnessCollection = map.get((Object)Attributes.f_22285_);
            AttributeModifier armorModifier = (AttributeModifier)armorCollection.toArray()[0];
            AttributeModifier toughnessModifier = (AttributeModifier)toughnessCollection.toArray()[0];
            double baseArmor = armorModifier.m_22218_();
            double baseToughness = toughnessModifier.m_22218_();
            double newArmor = rarity.getWeightedArmor(baseArmor);
            double newToughness = rarity.generateWeightedArmorToughness(baseToughness);
            AttributeModifier armor = new AttributeModifier(MinecraftAttributes.ARMOR_UUID, "armor", newArmor, AttributeModifier.Operation.ADDITION);
            AttributeModifier toughness = new AttributeModifier(MinecraftAttributes.ARMOR_TOUGHNESS_UUID, "armorToughness", newToughness, AttributeModifier.Operation.ADDITION);
            stack.m_41643_(Attributes.f_22284_, armor, slot);
            stack.m_41643_(Attributes.f_22285_, toughness, slot);
        }
    }
}

