/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.leveling.attributes;

import com.thexfactor117.levels.common.color.LegacyTextColor;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeRarity;
import com.thexfactor117.levels.common.leveling.attributes.components.config.SimpleConfigAttribute;
import com.thexfactor117.levels.common.nbt.INBT;
import lombok.Generated;

public enum BowAttribute implements AttributeBase,
SimpleConfigAttribute
{
    RECOVER("Recover", LegacyTextColor.DARK_AQUA, AttributeRarity.RARE, 0.0, 0.0, 1),
    BARRAGE("Barrage", LegacyTextColor.DARK_RED, AttributeRarity.LEGENDARY, 3.0, 1.5, 3);

    private final String baseKey;
    private final String baseName;
    private final String color;
    private final int hexColor;
    private final AttributeRarity rarity;
    private final double defaultBaseValue;
    private final double defaultMultiplier;
    private final int defaultMaxLevel;

    private BowAttribute(String baseName, LegacyTextColor color, AttributeRarity rarity, double defaultBaseValue, double defaultMultiplier, int defaultMaxLevel) {
        this.baseName = baseName;
        this.color = color.toString();
        this.hexColor = color.getHex();
        this.rarity = rarity;
        this.defaultBaseValue = defaultBaseValue;
        this.defaultMultiplier = defaultMultiplier;
        this.defaultMaxLevel = defaultMaxLevel;
        this.baseKey = SimpleConfigAttribute.keyOf(this);
    }

    @Override
    public boolean isEnabled() {
        return SimpleConfigAttribute.super.isEnabled();
    }

    @Override
    public String getTranslationKey() {
        return "levels.attributes.bows.info." + this.ordinal();
    }

    @Override
    public ItemType[] getAllowedTypes() {
        return new ItemType[]{ItemType.BOW};
    }

    @Override
    public double getCalculatedValue(INBT nbt) {
        return this.getCalculatedValue(this.getAttributeTier(nbt));
    }

    @Override
    @Generated
    public String getBaseKey() {
        return this.baseKey;
    }

    @Override
    @Generated
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    @Generated
    public String getColor() {
        return this.color;
    }

    @Override
    @Generated
    public int getHexColor() {
        return this.hexColor;
    }

    @Override
    @Generated
    public AttributeRarity getRarity() {
        return this.rarity;
    }

    @Override
    @Generated
    public double getDefaultBaseValue() {
        return this.defaultBaseValue;
    }

    @Override
    @Generated
    public double getDefaultMultiplier() {
        return this.defaultMultiplier;
    }

    @Override
    @Generated
    public int getDefaultMaxLevel() {
        return this.defaultMaxLevel;
    }
}

