/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.events;

import com.thexfactor117.levels.bukkit.leveling.Experience;
import com.thexfactor117.levels.bukkit.libs.xseries.XAttribute;
import com.thexfactor117.levels.bukkit.libs.xseries.XPotion;
import com.thexfactor117.levels.bukkit.nbt.NBTHelper;
import com.thexfactor117.levels.bukkit.nbt.NBTImpl;
import com.thexfactor117.levels.bukkit.util.ItemUtil;
import com.thexfactor117.levels.bukkit.util.StackUtil;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.ArmorAttribute;
import com.thexfactor117.levels.common.leveling.attributes.BowAttribute;
import com.thexfactor117.levels.common.leveling.attributes.SwordAttribute;
import com.thexfactor117.levels.common.leveling.attributes.WeaponAttributes;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class EventAttack
implements Listener {
    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onAttack(EntityDamageByEntityEvent event) {
        Entity source = event.getDamager();
        Entity victim = event.getEntity();
        boolean dead = victim.isDead();
        if (!dead) {
            if (source instanceof Player) {
                Player player = (Player)source;
                if (victim instanceof LivingEntity) {
                    LivingEntity enemy = (LivingEntity)victim;
                    ItemStack stack = player.getInventory().getItemInMainHand();
                    if (!ItemUtil.isSword(stack.getType())) return;
                    this.processHit(event, stack, enemy, player);
                    return;
                }
            }
            if (source instanceof LivingEntity && victim instanceof Player) {
                Player player = (Player)victim;
                LivingEntity enemy = (LivingEntity)source;
                this.processArmorHit(event, player, enemy);
                return;
            }
            if (!(source instanceof Arrow)) return;
            if (!(victim instanceof LivingEntity)) return;
            Arrow arrow = (Arrow)source;
            ProjectileSource shooter = arrow.getShooter();
            if (shooter == null) {
                return;
            }
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                LivingEntity enemy = (LivingEntity)victim;
                ItemStack stack = player.getInventory().getItemInMainHand();
                if (stack.getType() != Material.BOW) return;
                this.processHit(event, stack, enemy, player);
                return;
            }
            if (!(shooter instanceof LivingEntity)) return;
            if (!(victim instanceof Player)) return;
            Player player = (Player)victim;
            LivingEntity enemy = (LivingEntity)shooter;
            this.processArmorHit(event, player, enemy);
            return;
        }
        if (source instanceof Player && victim instanceof LivingEntity) {
            Player player = (Player)source;
            LivingEntity enemy = (LivingEntity)victim;
            ItemStack stack = player.getInventory().getItemInMainHand();
            ItemMeta meta = stack.getItemMeta();
            if (meta == null) return;
            if (!ItemUtil.isSword(stack.getType())) return;
            this.processDeath(stack, meta, enemy, player);
            stack.setItemMeta(meta);
            return;
        }
        if (!(source instanceof Arrow)) return;
        Arrow arrow = (Arrow)source;
        ProjectileSource shooter = arrow.getShooter();
        if (shooter == null) {
            return;
        }
        if (!(shooter instanceof Player)) return;
        if (!(victim instanceof LivingEntity)) return;
        Player player = (Player)shooter;
        LivingEntity enemy = (LivingEntity)victim;
        ItemStack stack = player.getInventory().getItemInMainHand();
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) return;
        if (stack.getType() != Material.BOW) {
            return;
        }
        this.processDeath(stack, meta, enemy, player);
        NBTImpl inbt = NBTHelper.toCommon(meta.getPersistentDataContainer());
        if (BowAttribute.RECOVER.hasAttribute(inbt)) {
            enemy.getLocation().getWorld().dropItem(enemy.getLocation(), new ItemStack(Material.ARROW, (int)(Math.random() * 2.0)));
        }
        stack.setItemMeta(meta);
    }

    private void processDeath(ItemStack stack, ItemMeta meta, LivingEntity enemy, Player player) {
        this.addExperience(stack, meta, enemy);
        this.useRarity(stack, meta, true);
        this.attemptLevel(stack, meta, player);
    }

    private void processArmorHit(EntityDamageByEntityEvent event, Player player, LivingEntity enemy) {
        for (ItemStack stack : player.getInventory().getArmorContents()) {
            if (stack == null) continue;
            this.processHit(event, stack, enemy, player);
        }
        ItemStack shield = player.getInventory().getItemInOffHand();
        if (shield.getType() == Material.SHIELD && player.isHandRaised()) {
            this.processHit(event, shield, enemy, player);
        }
    }

    private void processHit(EntityDamageByEntityEvent event, ItemStack stack, LivingEntity enemy, Player player) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return;
        }
        this.addExperience(stack, meta, enemy);
        this.useRarity(stack, meta, false);
        this.useAttributes(event, stack, meta, player, enemy);
        this.attemptLevel(stack, meta, player);
        stack.setItemMeta(meta);
    }

    private void addExperience(ItemStack stack, ItemMeta meta, LivingEntity enemy) {
        int xp;
        Experience exp = new Experience(stack, meta);
        if (exp.isMaxLevel()) {
            return;
        }
        Material type = stack.getType();
        if (type.toString().contains("SWORD") || type == Material.BOW) {
            xp = (int)(enemy.getMaxHealth() * 0.2);
            exp.addExperience(xp);
        }
        if (ItemUtil.isArmor(type) || type == Material.SHIELD) {
            xp = 0;
            xp = enemy.getAttribute((Attribute)XAttribute.ATTACK_DAMAGE.get()) != null ? (int)(enemy.getAttribute((Attribute)XAttribute.ATTACK_DAMAGE.get()).getValue() * 0.5) : (int)(enemy.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).getValue() * 0.5);
            exp.addExperience(xp);
        }
    }

    private void useRarity(ItemStack stack, ItemMeta meta, boolean death) {
        NBTImpl inbt = NBTHelper.toCommon(meta.getPersistentDataContainer());
        Rarity rarity = Rarity.getRarity(inbt);
        if (rarity == Rarity.DEFAULT) {
            return;
        }
        boolean isUnlimitedDurability = Configs.getInstance().main.getBoolean("unlimitedDurability");
        Experience exp = new Experience(stack, meta);
        ItemType type = ItemUtil.type(stack.getType());
        if (type != null && death) {
            int addedXp = rarity.generateExperience();
            exp.addExperience(addedXp);
        }
        if (!isUnlimitedDurability && !death) {
            int repairDurability = rarity.generateRarityRepair();
            StackUtil.safeRepair(meta, repairDurability);
        }
    }

    private void useAttributes(EntityDamageByEntityEvent event, ItemStack stack, ItemMeta meta, Player player, LivingEntity enemy) {
        Material type;
        NBTImpl nbt = NBTHelper.toCommon(meta.getPersistentDataContainer());
        if (AnyAttributes.FIRE.hasAttribute(nbt) && AnyAttributes.FIRE.rollChance()) {
            enemy.setFireTicks((int)AnyAttributes.FIRE.getCalculatedValue(nbt) * 20);
        }
        if (AnyAttributes.FROST.hasAttribute(nbt) && AnyAttributes.FROST.rollChance()) {
            int calculated = (int)AnyAttributes.FROST.getCalculatedValue(nbt);
            enemy.addPotionEffect(new PotionEffect(XPotion.SLOWNESS.getPotionEffectType(), calculated, 10));
            enemy.setFreezeTicks(calculated * 4);
        }
        if (AnyAttributes.POISON.hasAttribute(nbt) && AnyAttributes.POISON.rollChance()) {
            enemy.addPotionEffect(new PotionEffect(XPotion.POISON.getPotionEffectType(), (int)AnyAttributes.POISON.getCalculatedValue(nbt), AnyAttributes.POISON.getAttributeTier(nbt)));
        }
        if (AnyAttributes.DURABLE.hasAttribute(nbt) && AnyAttributes.DURABLE.rollChance()) {
            int repair = (int)AnyAttributes.DURABLE.getCalculatedValue(nbt);
            StackUtil.safeRepair(meta, repair);
        }
        double dmgAmount = event.getDamage();
        if (WeaponAttributes.ABSORB.hasAttribute(nbt) && WeaponAttributes.ABSORB.rollChance()) {
            float regenAmount = (float)(dmgAmount * WeaponAttributes.ABSORB.getCalculatedValue(nbt) / 100.0);
            player.setHealth(player.getHealth() + (double)regenAmount);
        }
        if (WeaponAttributes.VOID.hasAttribute(nbt)) {
            double chance = WeaponAttributes.VOID.getCalculatedValue(nbt);
            if (Math.random() * 100.0 <= chance) {
                enemy.setHealth((double)0.001f);
            }
        }
        if (WeaponAttributes.CRITICAL.hasAttribute(nbt) && WeaponAttributes.CRITICAL.rollChance()) {
            float bonus = (float)(dmgAmount * WeaponAttributes.CRITICAL.getCalculatedValue(nbt) / 100.0);
            event.setDamage(dmgAmount + (double)bonus);
        }
        if (ItemUtil.isSword(type = stack.getType()) && SwordAttribute.CHAINED.hasAttribute(nbt) && SwordAttribute.CHAINED.rollChance()) {
            double radius = SwordAttribute.CHAINED.getCalculatedValue(nbt);
            World world = enemy.getWorld();
            Collection entityCollection = world.getNearbyEntities(player.getLocation(), radius, radius, radius, LivingEntity.class::isInstance);
            for (Entity entity : entityCollection) {
                LivingEntity living = (LivingEntity)entity;
                if (entity instanceof Player || !(living instanceof Monster)) continue;
                ((Monster)entity).damage(dmgAmount / 2.0, (Entity)player);
            }
        }
        if (ItemUtil.isArmor(type)) {
            double magicDmg = event.getDamage(EntityDamageEvent.DamageModifier.MAGIC);
            if (ArmorAttribute.MAGICAL.hasAttribute(nbt) && (int)Math.floor(magicDmg) == 0) {
                event.setDamage(EntityDamageEvent.DamageModifier.MAGIC, (double)((float)(magicDmg * ArmorAttribute.MAGICAL.getCalculatedValue(nbt) / 100.0)));
            }
        }
    }

    private void attemptLevel(ItemStack stack, ItemMeta meta, Player player) {
        new Experience.LevelUp(new Experience(stack, meta), player).levelUp();
    }
}

