/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.events;

import com.thexfactor117.levels.bukkit.util.ItemUtil;
import com.thexfactor117.levels.bukkit.util.WeaponHelper;
import com.thexfactor117.levels.common.config.ConfigManager;
import com.thexfactor117.levels.common.config.Configs;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EventCreateWeapon
implements Runnable {
    private static final Map<Material, ItemMeta> DEFAULT_META = new EnumMap<Material, ItemMeta>(Material.class);

    @Override
    public void run() {
        ConfigManager main = Configs.getInstance().main;
        Set blackList = main.getStringSet("itemBlackList").stream().map(NamespacedKey::fromString).collect(Collectors.toSet());
        boolean patchCustom = main.getBoolean("patchCustomItems");
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (ItemStack stack : player.getInventory()) {
                NamespacedKey nsKey;
                Material type;
                if (stack == null || ItemUtil.type(type = stack.getType()) == null || blackList.contains(nsKey = type.getKey())) continue;
                if (stack.getItemMeta() == null) {
                    stack.setItemMeta(DEFAULT_META.computeIfAbsent(type, arg_0 -> ((ItemFactory)Bukkit.getItemFactory()).getItemMeta(arg_0)));
                } else if (!patchCustom && !stack.getItemMeta().getPersistentDataContainer().isEmpty()) continue;
                WeaponHelper.create(stack, player);
            }
        }
    }
}

