/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.inventory.AnvilInventory;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.inventory.CartographyInventory;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.util.InventoryUtils;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.util.ItemUtils;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.util.PlayerUtils;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.BungeeComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryAccess {
    private static final Class<InventoryUtils> INVENTORY_UTILS_CLASS = ReflectionUtils.getImplClass("InventoryUtilsImpl");
    private static final Class<ItemUtils> ITEM_UTILS_CLASS = ReflectionUtils.getImplClass("ItemUtilsImpl");
    private static final Class<PlayerUtils> PLAYER_UTILS_CLASS = ReflectionUtils.getImplClass("PlayerUtilsImpl");
    private static final Class<AnvilInventory> ANVIL_INVENTORY_CLASS = ReflectionUtils.getImplClass("AnvilInventoryImpl");
    private static final Class<CartographyInventory> CARTOGRAPHY_INVENTORY_CLASS = ReflectionUtils.getImplClass("CartographyInventoryImpl");
    private static final Constructor<AnvilInventory> ANVIL_INVENTORY_CONSTRUCTOR = ReflectionUtils.getConstructor(ANVIL_INVENTORY_CLASS, true, Player.class, ComponentWrapper.class, List.class);
    private static final Constructor<CartographyInventory> CARTOGRAPHY_INVENTORY_CONSTRUCTOR = ReflectionUtils.getConstructor(CARTOGRAPHY_INVENTORY_CLASS, true, Player.class, ComponentWrapper.class);
    private static final InventoryUtils INVENTORY_UTILS = (InventoryUtils)ReflectionUtils.constructEmpty(INVENTORY_UTILS_CLASS);
    private static final ItemUtils ITEM_UTILS = (ItemUtils)ReflectionUtils.constructEmpty(ITEM_UTILS_CLASS);
    private static final PlayerUtils PLAYER_UTILS = (PlayerUtils)ReflectionUtils.constructEmpty(PLAYER_UTILS_CLASS);

    public static InventoryUtils getInventoryUtils() {
        return INVENTORY_UTILS;
    }

    public static ItemUtils getItemUtils() {
        return ITEM_UTILS;
    }

    public static PlayerUtils getPlayerUtils() {
        return PLAYER_UTILS;
    }

    public static AnvilInventory createAnvilInventory(@NotNull Player player, @Nullable ComponentWrapper title, @Nullable List<@NotNull Consumer<String>> renameHandlers) {
        return ReflectionUtils.construct(ANVIL_INVENTORY_CONSTRUCTOR, player, title == null ? BungeeComponentWrapper.EMPTY : title, renameHandlers);
    }

    public static CartographyInventory createCartographyInventory(@NotNull Player player, @Nullable ComponentWrapper title) {
        return ReflectionUtils.construct(CARTOGRAPHY_INVENTORY_CONSTRUCTOR, player, title == null ? BungeeComponentWrapper.EMPTY : title);
    }
}

